\name{rema_mastocytosis_score}
\alias{rema_mastocytosis_score}
\title{
Spanish Network on Mastocytosis (REMA) Score
}
\description{
Calculates the REMA Score to predict the presence of clonal mast cell disease (Systemic Mastocytosis or Monoclonal Mast Cell Activation Syndrome) in patients with mast cell activation symptoms but without skin lesions (systemic mastocytosis sine urticaria pigmentosa). A score of 2 or higher suggests a higher probability of clonality and may warrant bone marrow biopsy.
}
\usage{
rema_mastocytosis_score(sex, clinical_symptoms, tryptase_level)
}
\arguments{
  \item{sex}{
String. Patient sex ("male" or "female").
Male: +2 points.
Female: -4 points.
}
  \item{clinical_symptoms}{
String. The primary clinical presentation.
"pruritus_urticaria_angioedema": Pruritus, urticaria, or angioedema (-4 points).
"syncope_presyncope": Syncope or presyncope (+3 points).
"anaphylaxis": Anaphylaxis (+1 point).
"other": Other symptoms (0 points).
}
  \item{tryptase_level}{
Numeric. Baseline serum tryptase level in ng/mL.
< 15: 0 points.
15 - 24.9: +1 point.
>= 25: +2 points.
}
}
\value{
A list containing:
\item{REMA_Score}{The calculated total score (Range -8 to +7).}
\item{Prediction}{Interpretation of probability (Low < 2, High >= 2).}
\item{Test_Characteristics_at_Cutoff_2}{Sensitivity and Specificity metrics.}
}
\references{
Alvarez-Twose I, González-de-Olano D, Sánchez-Muñoz L, et al. Clinical, biological, and molecular characteristics of clonal mast cell disorders presenting with systemic mast cell activation symptoms. J Allergy Clin Immunol. 2010;125(6):1269-1278.e2. doi:10.1016/j.jaci.2010.02.019
}
\examples{

# Example 1: High Probability
# Male (+2), Syncope (+3), Tryptase 20 (+1)
# Score = 6
rema_mastocytosis_score("male", "syncope_presyncope", 20)

# Example 2: Low Probability
# Female (-4), Urticaria (-4), Tryptase 10 (0)
# Score = -8
rema_mastocytosis_score("female", "pruritus_urticaria_angioedema", 10)
}
