\name{plasmic_score_ttp}
\alias{plasmic_score_ttp}
\title{
PLASMIC Score for TTP
}
\description{
Calculates the PLASMIC score to predict the likelihood of severe ADAMTS13 deficiency (<10\%) in patients with suspected Thrombotic Thrombocytopenic Purpura (TTP). The score is based on 7 clinical and laboratory parameters.
}
\usage{
plasmic_score_ttp(platelet_count, hemolysis_evidence, active_cancer,
                  stem_cell_or_organ_transplant, mcv_lt_90, inr_lt_1_5,
                  creatinine_lt_2_0)
}
\arguments{
  \item{platelet_count}{
Numeric. Platelet count in x10^9/L (or x10^3/uL). (<30 adds 1 point).
}
  \item{hemolysis_evidence}{
Numeric (0 or 1). Evidence of hemolysis (e.g., reticulocyte count >2.5\%, undetectable haptoglobin, or indirect bilirubin >2 mg/dL). (1 = Yes, adds 1 point).
}
  \item{active_cancer}{
Numeric (0 or 1). Active cancer (treated within the last year). (0 = No, adds 1 point).
}
  \item{stem_cell_or_organ_transplant}{
Numeric (0 or 1). History of solid organ or hematopoietic stem cell transplant. (0 = No, adds 1 point).
}
  \item{mcv_lt_90}{
Numeric (0 or 1). Mean Corpuscular Volume (MCV) < 90 fL. (1 = Yes, adds 1 point).
}
  \item{inr_lt_1_5}{
Numeric (0 or 1). International Normalized Ratio (INR) < 1.5. (1 = Yes, adds 1 point).
}
  \item{creatinine_lt_2_0}{
Numeric (0 or 1). Serum Creatinine < 2.0 mg/dL. (1 = Yes, adds 1 point).
}
}
\value{
A list containing:
\item{PLASMIC_Score}{The calculated total score (Range 0-7).}
\item{Risk_Category}{Risk classification (Low, Intermediate, High).}
\item{TTP_Probability}{Estimated probability of severe ADAMTS13 deficiency.}
}
\references{
Bendapudi PK, Hurwitz S, Fry A, et al. Derivation and external validation of the PLASMIC score for rapid assessment of thrombotic microangiopathy: A cohort study. Lancet Haematol. 2017;4(4):e157-e164. doi:10.1016/S2352-3026(17)30026-1
}
\examples{

# Example 1: High Risk
# Plt 20 (<30, +1), Hemolysis (+1), No cancer (+1),
#No transplant (+1), MCV 85 (+1), INR 1.2 (+1), Cr 1.0 (+1)
# Score = 7
plasmic_score_ttp(20, 1, 0, 0, 1, 1, 1)

# Example 2: Low Risk
# Plt 100 (0), Hemolysis (+1), Active cancer (0),
#Transplant (0), MCV 95 (0), INR 1.8 (0), Cr 3.0 (0)
# Score = 1
plasmic_score_ttp(100, 1, 1, 1, 0, 0, 0)
}
