\name{news_score}
\alias{news_score}
\title{
National Early Warning Score (NEWS)
}
\description{
Calculates the National Early Warning Score (NEWS) to standardize the assessment of acute illness severity. The score is based on seven physiological parameters: Respiratory Rate, Oxygen Saturation, Supplemental Oxygen use, Temperature, Systolic BP, Heart Rate, and AVPU score.
}
\usage{
news_score(respiratory_rate, oxygen_saturation, any_supplemental_oxygen,
           temperature_c, systolic_bp, heart_rate, avpu_score)
}
\arguments{
  \item{respiratory_rate}{
Numeric. Respiratory rate in breaths per minute.
}
  \item{oxygen_saturation}{
Numeric. Oxygen saturation percentage (SpO2).
}
  \item{any_supplemental_oxygen}{
Numeric (0 or 1). Is the patient receiving supplemental oxygen? (1 = Yes, +2 points).
}
  \item{temperature_c}{
Numeric. Body temperature in degrees Celsius.
}
  \item{systolic_bp}{
Numeric. Systolic blood pressure in mmHg.
}
  \item{heart_rate}{
Numeric. Heart rate in beats per minute.
}
  \item{avpu_score}{
String. Level of consciousness: "alert", "voice", "pain", "unresponsive". Any response other than "alert" scores 3 points.
}
}
\value{
A list containing:
\item{NEWS_Score}{The calculated total score (Range 0-20).}
\item{Risk_Category}{Classification of clinical risk (Low, Medium, High).}
\item{Response_Level}{Recommended clinical response urgency.}
}
\references{
Royal College of Physicians. National Early Warning Score (NEWS): Standardising the assessment of acute-illness severity in the NHS. Report of a working party. London: RCP, 2012.
}
\examples{

# Example 1: Low Risk
# RR 18, SpO2 98, No O2, Temp 37, SBP 130, HR 70, Alert
news_score(18, 98, 0, 37.0, 130, 70, "alert")

# Example 2: High Risk
# RR 26 (+3), SpO2 90 (+3), On O2 (+2), Temp 39 (+1), SBP 100 (+1), HR 120 (+2), Verbal (+3)
# Score = 15
news_score(26, 90, 1, 39.0, 100, 120, "voice")
}
