\name{lips_score}
\alias{lips_score}
\title{
Lung Injury Prediction Score (LIPS)
}
\description{
Calculates the Lung Injury Prediction Score (LIPS) to identify patients at high risk for developing Acute Lung Injury (ALI) or Acute Respiratory Distress Syndrome (ARDS). The score sums points for predisposing conditions (like shock, aspiration, sepsis) and risk modifiers (like alcohol use, obesity, and vital signs). A score of 4 or greater typically indicates high risk.
}
\usage{
lips_score(shock, aspiration, sepsis, pneumonia, high_risk_surgery,
           high_risk_trauma, alcohol_abuse, obesity_bmi_gt_30, hypoalbuminemia,
           chemotherapy, fio2_gt_0_35_or_4l, tachypnea_rr_gt_30, spo2_lt_95,
           acidosis_ph_lt_7_35, diabetes_mellitus)
}
\arguments{
  \item{shock}{
Numeric (0 or 1). Presence of shock (Cardiogenic, Septic, or Hypovolemic). (1 = Yes, +2 pts).
}
  \item{aspiration}{
Numeric (0 or 1). Aspiration. (1 = Yes, +2 pts).
}
  \item{sepsis}{
Numeric (0 or 1). Sepsis. (1 = Yes, +1 pt).
}
  \item{pneumonia}{
Numeric (0 or 1). Pneumonia. (1 = Yes, +1.5 pts).
}
  \item{high_risk_surgery}{
Numeric (0 or 1). High-risk surgery (Aortic vascular, Cardiac, Emergency, Spine). (1 = Yes, +2 pts).
}
  \item{high_risk_trauma}{
Numeric (0 or 1). High-risk trauma (TBI, Smoke inhalation, Near drowning, Lung contusion, Multiple fractures). (1 = Yes, +2 pts).
}
  \item{alcohol_abuse}{
Numeric (0 or 1). Alcohol abuse. (1 = Yes, +1 pt).
}
  \item{obesity_bmi_gt_30}{
Numeric (0 or 1). Obesity (BMI > 30). (1 = Yes, +1 pt).
}
  \item{hypoalbuminemia}{
Numeric (0 or 1). Hypoalbuminemia (Albumin < 3.5 g/dL). (1 = Yes, +1 pt).
}
  \item{chemotherapy}{
Numeric (0 or 1). Chemotherapy. (1 = Yes, +1 pt).
}
  \item{fio2_gt_0_35_or_4l}{
Numeric (0 or 1). FiO2 > 0.35 or > 4 L/min O2 (sometimes noted as >2 L/min in variations). (1 = Yes, +2 pts).
}
  \item{tachypnea_rr_gt_30}{
Numeric (0 or 1). Respiratory rate > 30 bpm. (1 = Yes, +1.5 pts).
}
  \item{spo2_lt_95}{
Numeric (0 or 1). SpO2 < 95\%. (1 = Yes, +1 pt).
}
  \item{acidosis_ph_lt_7_35}{
Numeric (0 or 1). Acidosis (pH < 7.35). (1 = Yes, +1 pt).
}
  \item{diabetes_mellitus}{
Numeric (0 or 1). Diabetes Mellitus. (1 = Yes, -1 pt). Note: Diabetes is protective in this model.
}
}
\value{
A list containing:
\item{LIPS_Score}{The calculated total score (Range -1 to >20).}
\item{Risk_Category}{"Low Risk" (< 4) or "High Risk" (>= 4).}
\item{Recommendation}{Clinical guidance for monitoring.}
}
\references{
Gajic O, Dabbagh O, Park PK, et al. Early identification of patients at risk of acute lung injury: evaluation of lung injury prediction score in a multicenter cohort study. Am J Respir Crit Care Med. 2011;183(4):462-470. doi:10.1164/rccm.201004-0549OC
}
\examples{

# Example 1: High Risk
# Shock (+2), Sepsis (+1), Acidosis (+1), Hypoalbuminemia (+1)
# Score = 5
lips_score(1, 0, 1, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0)

# Example 2: Low Risk
# Pneumonia (+1.5), Diabetes (-1), No other factors
# Score = 0.5
lips_score(0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1)
}
