\name{bode_index_copd}
\alias{bode_index_copd}
\title{
BODE Index for COPD Survival
}
\description{
Calculates the BODE Index, a multidimensional scoring system to predict mortality in patients with Chronic Obstructive Pulmonary Disease (COPD). The score evaluates Body mass index, Obstruction (FEV1), Dyspnea (mMRC), and Exercise capacity (6MWD).
}
\usage{
bode_index_copd(bmi, fev1_percent_predicted, mmrc_scale,
                six_minute_walk_distance_m)
}
\arguments{
  \item{bmi}{
Numeric. Body Mass Index (kg/m^2). (> 21: 0 pts; <= 21: 1 pt).
}
  \item{fev1_percent_predicted}{
Numeric. FEV1 percent predicted. (>= 65: 0 pts; 50-64: 1 pt; 36-49: 2 pts; <= 35: 3 pts).
}
  \item{mmrc_scale}{
Numeric (0-4). Modified Medical Research Council (mMRC) Dyspnea Scale.
0-1: 0 pts.
2: 1 pt.
3: 2 pts.
4: 3 pts.
}
  \item{six_minute_walk_distance_m}{
Numeric. 6-Minute Walk Distance in meters. (>= 350: 0 pts; 250-349: 1 pt; 150-249: 2 pts; <= 149: 3 pts).
}
}
\value{
A list containing:
\item{BODE_Index}{The calculated score (Range 0-10).}
\item{Est_4_Year_Survival}{Estimated 4-year survival probability.}
}
\references{
Celli BR, Cote CG, Marin JM, et al. The body-mass index, airflow obstruction, dyspnea, and exercise capacity index in chronic obstructive pulmonary disease. N Engl J Med. 2004;350(10):1005-1012. doi:10.1056/NEJMoa021322
}
\examples{

# Example 1: Severe COPD (High Mortality Risk)
# BMI 20 (+1), FEV1 30\% (+3), mMRC 3 (+2), 6MWD 140m (+3)
# Score = 9
bode_index_copd(20, 30, 3, 140)

# Example 2: Moderate COPD
# BMI 25 (0), FEV1 55\% (+1), mMRC 1 (0), 6MWD 300m (+1)
# Score = 2
bode_index_copd(25, 55, 1, 300)
}
