% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_report.R
\name{export_report}
\alias{export_report}
\title{Export Comparison Report to File}
\usage{
export_report(result, file, format = NULL)
}
\arguments{
\item{result}{A list from \code{\link[=compare_datasets]{compare_datasets()}} or \code{\link[=cdisc_compare]{cdisc_compare()}}.}

\item{file}{Character string specifying the output file path.
File extension determines format: .html, .txt, or .xlsx.}

\item{format}{Character string specifying output format: "html", "text", or "excel".
If NULL (default), format is auto-detected from file extension.}
}
\value{
Invisibly returns the input \code{result} (useful for piping).
}
\description{
Exports a dataset or CDISC comparison result to a file in multiple formats.
Automatically detects format from file extension (.html, .txt, .xlsx).
}
\details{
Supported formats:
\itemize{
\item \strong{HTML} (.html): Self-contained HTML report with styling and interactive charts.
\item \strong{Text} (.txt): Plain text report suitable for console review.
\item \strong{Excel} (.xlsx): Multi-sheet workbook with tabbed data:
\itemize{
\item "Summary": Dataset dimensions, domain, standard, matching type, tolerance
\item "Variable Diffs": Metadata attribute differences
\item "Value Diffs": Unified diff data frame from \code{\link[=get_all_differences]{get_all_differences()}}
\item "CDISC Validation": Combined validation results (for CDISC comparisons only)
}
}

The result object can be either a \code{dataset_comparison} (from \code{\link[=compare_datasets]{compare_datasets()}})
or \code{cdisc_comparison} (from \code{\link[=cdisc_compare]{cdisc_compare()}}). All features are supported for both.
}
\examples{
\donttest{
# Create sample datasets
df1 <- data.frame(
  ID = c(1, 2, 3),
  NAME = c("Alice", "Bob", "Charlie"),
  AGE = c(25, 30, 35)
)

df2 <- data.frame(
  ID = c(1, 2, 3),
  NAME = c("Alice", "Bob", "Charles"),
  AGE = c(25, 30, 36)
)

# Compare datasets
result <- compare_datasets(df1, df2)

# Export to different formats (write to tempdir)
export_report(result, file.path(tempdir(), "report.html"))
export_report(result, file.path(tempdir(), "report.txt"))

# Explicit format specification
export_report(result, file.path(tempdir(), "report.xlsx"), format = "excel")
}
}
