% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{check_functions_in_file}
\alias{check_functions_in_file}
\title{Check All Functions Defined in a File}
\usage{
check_functions_in_file(path, ...)
}
\arguments{
\item{path}{Path to the file to be checked.}

\item{...}{Arguments to be passed to \code{\link{check_function_layout}}.}
}
\value{
\code{\link[base:invisible]{Invisibly}} \code{\link{TRUE}},
but see \emph{Details}.
}
\description{
Run \code{\link{check_function_layout}} on all functions defined in a file.
}
\details{
The functions catches the messages of "cleanr"-conditions
\code{\link{throw}}n by \code{\link{check_function_layout}} and,
if it caught any, \code{\link{throw}}s them.
}
\examples{
print(cleanr::check_functions_in_file(system.file("source", "R", "utils.R",
                                                  package = "cleanr")))
}
\seealso{
Other wrappers: 
\code{\link{check_directory}()},
\code{\link{check_file_layout}()},
\code{\link{check_file}()},
\code{\link{check_function_layout}()},
\code{\link{check_package}()}
}
\concept{wrappers}
