% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cja_get_audit_logs.R
\name{cja_get_audit_logs}
\alias{cja_get_audit_logs}
\title{Get audit logs}
\usage{
cja_get_audit_logs(
  startDate = NULL,
  endDate = NULL,
  action = NULL,
  component = NULL,
  componentId = NULL,
  userType = NULL,
  userId = NULL,
  userEmail = NULL,
  description = NULL,
  pageSize = 100,
  pageNumber = 0,
  debug = FALSE
)
}
\arguments{
\item{startDate}{Date is not required, but if you filter by date, both start & end date must be set.}

\item{endDate}{Date is not required, but if you filter by date, both start & end date must be set.}

\item{action}{The action you want to filter by.See details section for options}

\item{component}{The type of component you want to filter by. See details section for options}

\item{componentId}{The ID of the component.}

\item{userType}{The type of user.}

\item{userId}{The ID of the user.}

\item{userEmail}{The email address of the user.}

\item{description}{The log description you want to filter by.}

\item{pageSize}{Number of results per page. If left null, the default size will be set to 100.}

\item{pageNumber}{Page number (base 0 - first page is "0")}

\item{debug}{Used to help troubleshoot api call issues. Shows the call and result in the console}
}
\value{
A data frame of audit logs and corresponding metadata
}
\description{
This function will pull a list of audit logs defined by the different defined parameters.
}
\details{
\emph{startDate/endDate} format

\emph{Action} available values are: 'CREATE', 'EDIT', 'DELETE', 'LOGIN_FAILED',
'LOGIN_SUCCESSFUL', 'API_REQUEST', 'LOGOUT', 'APPROVE', 'UNAPPROVE', 'SHARE', 'UNSHARE',
'TRANSFER', 'ORG_CHANGE'

\emph{Component} available values are: 'ANNOTATION', 'CALCULATED_METRIC', 'CONNECTION',
'DATA_GROUP', 'DATA_VIEW', 'DATE_RANGE', 'FILTER', 'MOBILE', 'PROJECT',
'REPORT', 'SCHEDULED_PROJECT', 'USER', 'USER_GROUP', 'IMS_ORG',
'FEATURE_ACCESS'
}
\examples{
\dontrun{
cja_get_audit_logs()
}
}
