% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{enhancements_patch_identity_resolution}
\alias{enhancements_patch_identity_resolution}
\title{Update some attributes of this Identity Resolution Enhancement}
\usage{
enhancements_patch_identity_resolution(
  id,
  name = NULL,
  schedule = NULL,
  notifications = NULL,
  threshold = NULL,
  sources = NULL,
  match_target_id = NULL,
  enforced_links = NULL,
  customer_graph = NULL,
  golden_table = NULL,
  link_scores = NULL
)
}
\arguments{
\item{id}{integer required. The ID for the enhancement.}

\item{name}{string optional. The name of the enhancement job.}

\item{schedule}{list optional. A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}

\item{notifications}{list optional. A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on. Defaults to user's preferences.
\item failureOn boolean, If failure email notifications are on. Defaults to user's preferences.
}}

\item{threshold}{number optional. A value that determines the extent to which similar records get assigned the same resolved ID. Must be within 0.5 and 1, inclusive. Defaults to 0.8 if unspecified.Higher values may result in fewer cases where records about different individuals erroneously receive the same resolved ID, but also more more cases where records about the same individual receive different resolved IDs.}

\item{sources}{array optional. An array containing the following fields: 
\itemize{
\item name string, A user-specified name for the source.
\item description string, A description of the source.
\item databaseName string, The name of the source database.
\item schemaName string, The name of the source schema.
\item tableName string, The name of the source table.
\item fieldMapping object, A mapping of PII fields to columns in this table. Valid keys are primary_key, first_name, middle_name, last_name, gender, phone, email, birth_date, birth_year, birth_month, birth_day, house_number, street, unit, full_address, city, state, state_code, zip, lat, lon, and name_suffix
}}

\item{match_target_id}{integer optional. The ID of the Civis Data (Custom) match target. See /match_targets for IDs.}

\item{enforced_links}{array optional. An array containing the following fields: 
\itemize{
\item source1 string, Name of the first source. Must be defined in Sources list.
\item source1JoinCol string, Column from the first source to join on.
\item source2 string, Name of the second source. Must be defined in Sources list
\item source2JoinCol string, Column from the second source to join on.
}}

\item{customer_graph}{list optional. A list containing the following elements: 
\itemize{
\item databaseName string, The name of the destination database.
\item schemaName string, The name of the destination schema.
\item tableName string, The name of the destination table.
}}

\item{golden_table}{list optional. A list containing the following elements: 
\itemize{
\item databaseName string, The name of the destination database.
\item schemaName string, The name of the destination schema.
\item tableName string, The name of the destination table.
\item fields array, 
}}

\item{link_scores}{list optional. A list containing the following elements: 
\itemize{
\item databaseName string, The name of the destination database.
\item schemaName string, The name of the destination schema.
\item tableName string, The name of the destination table.
}}
}
\value{
A list containing the following elements:
\item{id}{integer, The ID for the enhancement.}
\item{name}{string, The name of the enhancement job.}
\item{type}{string, The type of the enhancement (e.g CASS-NCOA)}
\item{createdAt}{string, The time this enhancement was created.}
\item{updatedAt}{string, The time the enhancement was last updated.}
\item{author}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{state}{string, The status of the enhancement's last run}
\item{schedule}{list, A list containing the following elements: 
\itemize{
\item scheduled boolean, If the item is scheduled.
\item scheduledDays array, Days of the week, based on numeric value starting at 0 for Sunday. Mutually exclusive with scheduledDaysOfMonth
\item scheduledHours array, Hours of the day it is scheduled on.
\item scheduledMinutes array, Minutes of the day it is scheduled on.
\item scheduledRunsPerHour integer, Deprecated in favor of scheduled minutes.
\item scheduledDaysOfMonth array, Days of the month it is scheduled on, mutually exclusive with scheduledDays.
}}
\item{notifications}{list, A list containing the following elements: 
\itemize{
\item urls array, URLs to receive a POST request at job completion
\item successEmailSubject string, Custom subject line for success e-mail.
\item successEmailBody string, Custom body text for success e-mail, written in Markdown.
\item successEmailAddresses array, Addresses to notify by e-mail when the job completes successfully.
\item successEmailFromName string, Name from which success emails are sent; defaults to "Civis."
\item successEmailReplyTo string, Address for replies to success emails; defaults to the author of the job.
\item failureEmailAddresses array, Addresses to notify by e-mail when the job fails.
\item stallWarningMinutes integer, Stall warning emails will be sent after this amount of minutes.
\item successOn boolean, If success email notifications are on. Defaults to user's preferences.
\item failureOn boolean, If failure email notifications are on. Defaults to user's preferences.
}}
\item{runningAs}{list, A list containing the following elements: 
\itemize{
\item id integer, The ID of this user.
\item name string, This user's name.
\item username string, This user's username.
\item initials string, This user's initials.
\item online boolean, Whether this user is online.
}}
\item{myPermissionLevel}{string, Your permission level on the object. One of "read", "write", or "manage".}
\item{archived}{string, The archival status of the requested item(s).}
\item{threshold}{number, A value that determines the extent to which similar records get assigned the same resolved ID. Must be within 0.5 and 1, inclusive. Defaults to 0.8 if unspecified.Higher values may result in fewer cases where records about different individuals erroneously receive the same resolved ID, but also more more cases where records about the same individual receive different resolved IDs.}
\item{sources}{array, An array containing the following fields: 
\itemize{
\item name string, A user-specified name for the source.
\item description string, A description of the source.
\item databaseName string, The name of the source database.
\item schemaName string, The name of the source schema.
\item tableName string, The name of the source table.
\item fieldMapping object, A mapping of PII fields to columns in this table. Valid keys are primary_key, first_name, middle_name, last_name, gender, phone, email, birth_date, birth_year, birth_month, birth_day, house_number, street, unit, full_address, city, state, state_code, zip, lat, lon, and name_suffix
}}
\item{matchTargetId}{integer, The ID of the Civis Data (Custom) match target. See /match_targets for IDs.}
\item{enforcedLinks}{array, An array containing the following fields: 
\itemize{
\item source1 string, Name of the first source. Must be defined in Sources list.
\item source1JoinCol string, Column from the first source to join on.
\item source2 string, Name of the second source. Must be defined in Sources list
\item source2JoinCol string, Column from the second source to join on.
}}
\item{customerGraph}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The name of the destination database.
\item schemaName string, The name of the destination schema.
\item tableName string, The name of the destination table.
}}
\item{goldenTable}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The name of the destination database.
\item schemaName string, The name of the destination schema.
\item tableName string, The name of the destination table.
\item fields array, 
}}
\item{linkScores}{list, A list containing the following elements: 
\itemize{
\item databaseName string, The name of the destination database.
\item schemaName string, The name of the destination schema.
\item tableName string, The name of the destination table.
}}
\item{legacyId}{integer, ID of this pipeline in the legacy IDR service application.}
\item{lastRun}{list, A list containing the following elements: 
\itemize{
\item id integer, 
\item state string, 
\item createdAt string, The time that the run was queued.
\item startedAt string, The time that the run started.
\item finishedAt string, The time that the run completed.
\item error string, The error message for this run, if present.
\item config string, How the Identity Resolution job was configured for this run.
\item sampleRecordsQuery string, A SQL query to produce a sample of records to inspect.
\item expandClusterQuery string, A customizable query to view PII associated with resolved ids.
\item runMetrics list . A list containing the following elements: 
\itemize{
\item numRecords integer, The number of input records for this run.
\item uniqueIds integer, The number of distinct unique IDs in the input records for this run.
\item uniqueDeduplicatedIds integer, The number of resolved IDs associated with more than one unique ID in the input.
\item maxClusterSize integer, The number of records in the largest cluster of resolved IDs.
\item avgClusterSize number, The average number of records with the same resolved ID.
\item clusterSizeFrequencies object, A mapping from numbers of records with the same resolved ID (i.e., sizes of clusters) to numbers of such clusters. For example, if there were 10 clusters with 2 records each, 2 would be a key in the mapping, and 10 would be its value.
}
\item errorSection string, If there was a failure, this will denote which section of the Identity Resolution job failed. One of: data_preparation, compute_setup or data_processing.
}}
}
\description{
Update some attributes of this Identity Resolution Enhancement
}
