% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generated_client.R
\name{clusters_get_kubernetes_partitions}
\alias{clusters_get_kubernetes_partitions}
\title{Describe a Cluster Partition}
\usage{
clusters_get_kubernetes_partitions(
  id,
  cluster_partition_id,
  include_usage_stats = NULL
)
}
\arguments{
\item{id}{integer required. The ID of the cluster which this partition belongs to.}

\item{cluster_partition_id}{integer required. The ID of this cluster partition.}

\item{include_usage_stats}{boolean optional. When true, usage stats are returned in instance config objects. Defaults to false.}
}
\value{
A list containing the following elements:
\item{clusterPartitionId}{integer, The ID of this cluster partition.}
\item{name}{string, The name of the cluster partition.}
\item{labels}{array, Labels associated with this partition.}
\item{instanceConfigs}{array, An array containing the following fields: 
\itemize{
\item instanceConfigId integer, The ID of this InstanceConfig.
\item instanceType string, An EC2 instance type. Possible values include t2.large, m4.xlarge, m4.2xlarge, m4.4xlarge, m5.12xlarge, c5.18xlarge, and g6.2xlarge.
\item minInstances integer, The minimum number of instances of that type in this cluster.
\item maxInstances integer, The maximum number of instances of that type in this cluster.
\item instanceMaxMemory integer, The amount of memory (RAM) available to a single instance of that type in megabytes.
\item instanceMaxCpu integer, The number of processor shares available to a single instance of that type in millicores.
\item instanceMaxDisk integer, The amount of disk available to a single instance of that type in gigabytes.
\item usageStats object, 
}}
\item{defaultInstanceConfigId}{integer, The id of the InstanceConfig that is the default for this partition.}
}
\description{
Describe a Cluster Partition
}
