% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnn.R
\name{linear}
\alias{linear}
\title{Linear layer}
\usage{
linear(
  n_neurons = NULL,
  bias = NULL,
  activation = NULL,
  normalization = NULL,
  dropout = NULL
)
}
\arguments{
\item{n_neurons}{(int) amount of hidden neurons in this layer}

\item{bias}{(boolean) if TRUE, adds a learnable bias to the neurons of this layer}

\item{activation}{(string) activation function that is used after this layer. The following activation functions are supported: "relu", "leaky_relu", "tanh", "elu", "rrelu", "prelu", "softplus", "celu", "selu", "gelu", "relu6", "sigmoid", "softsign", "hardtanh", "tanhshrink", "softshrink", "hardshrink", "log_sigmoid"}

\item{normalization}{(boolean) if TRUE, batch normalization is used after this layer}

\item{dropout}{(float) dropout rate of this layer. Set to 0 for no dropout}
}
\value{
S3 object of class \code{"linear" "citolayer"}
}
\description{
creates a 'linear' 'citolayer' object that is used by \code{\link{create_architecture}}.
}
\details{
This function creates a 'linear' 'citolayer' object that is passed to the \code{\link{create_architecture}} function.
The parameters that aren't assigned here (and are therefore still NULL) are filled with the default values passed to \code{\link{create_architecture}}.
}
\seealso{
\code{\link{create_architecture}}
}
\author{
Armin Schenk
}
