% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwJf.R
\name{bwJf}
\alias{bwJf}
\title{Plug-in Method by Tsuruta and Sagae with additive Jones-Foster approach}
\usage{
bwJf(x, verbose = FALSE)
}
\arguments{
\item{x}{Data from which the smoothing parameter is to be computed. The object is
coerced to a numeric vector in radians using \code{\link[circular]{circular}}.
Can be a numeric vector or an object of class \code{circular}.}

\item{verbose}{Logical indicating whether to print intermediate computational values
for debugging and teaching purposes. Shows kappa_hat, r_hat, and component
calculations. Default is FALSE.}
}
\value{
The computed optimal smoothing parameter \code{kappa}, a numeric concentration
parameter (analogous to inverse radians) derived from the circular version of the
additive method for circular kernel density estimation. Higher values indicate sharper,
more concentrated kernels and less smoothing; lower values indicate broader kernels
and more smoothing.
}
\description{
This function computes the optimal smoothing parameter (bandwidth) for circular data
using the plug-in method introduced by Tsuruta and Sagae (see \doi{10.1016/j.spl.2017.08.003}) with the
additive method from Jones and Foster (1993) to form higher-order kernel functions.
}
\details{
The plug-in approach estimates the optimal bandwidth through the following steps:
\enumerate{
\item Apply the additive method from Jones and Foster (1993) to construct a p-th order kernel function.
\item Derive expression for asymptotic mean integrated squared error (AMISE) expression.
\item Solving for the bandwidth that minimizes the AMISE. The optimal
bandwidth for the additive Jones-Foster method is given by:
\deqn{\hat{\kappa}_{JF} = \left[\frac{16\sqrt{\pi}}{3} \hat{R}_{\hat{\tau}}\left(\frac{5f_{VM}^{(2)} + 2f_{VM}^{(4)}}{12}\right)n\right]^{2/9}}
where the functional \eqn{\hat{R}_{\hat{\tau}}} is computed as a weighted linear combination under the von Mises assumption
and \eqn{\hat{\tau}} is the MLE estimate of the von Mises concentration parameter used as the initial value.
}
}
\examples{
# Example with circular data
library(circular)
set.seed(123)
x <- rvonmises(100, mu = circular(0), kappa = 2)
bw <- bwJf(x)
print(bw)

x <- rwrappednormal(100, mu = circular(1), rho = 0.7)
bw <- bwJf(x)
print(bw)

}
\references{
Tsuruta, Yasuhito & Sagae, Masahiko (2017). Higher order kernel density
estimation on the circle. \emph{Statistics & Probability Letters}, 131:46--50.
\doi{10.1016/j.spl.2017.08.003}

Jones, M. C. & Foster, P. J. (1993). Generalized jackknifing and higher-order kernels.
\emph{Journal of Nonparametric Statistics}, 3:81--94.
\doi{10.1080/10485259308832573}
}
\seealso{
\link{bwScv}, \link{bwLscvg}, \link{bwCcv}
}
