% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trifid_delastelle.R
\name{trifid_delastelle}
\alias{trifid_delastelle}
\title{trifid_delastelle}
\usage{
trifid_delastelle(input, key = "", period = 100, encrypt = TRUE)
}
\arguments{
\item{input}{Word or phrase to be encrypted,
or character vector with the sequence of coordinate numbers if we need to decrypt}

\item{key}{key Word for creating the modified Polybius square}

\item{period}{period length for splitting the input phrase. If greater or equal to the length of the input then the split is not executed}

\item{encrypt}{If `TRUE` (default), the program ciphers the input word, If `FALSE`, the program decrypts it.}
}
\value{
a string
}
\description{
The trifid cipher is an encryption method that uses a 3-dimensional grid 
It was invented by Felix Delastelle in 1902. As a 3x3x3 grid is used, 27 character are needed.
Thus, we use all the 26 alphabet letter and add the "+" sign at the bottom.
}
\examples{
trifid_delastelle("secret", key = "", period = 5, encrypt = TRUE)
trifid_delastelle("sjlkzt", key = "", period = 5, encrypt = FALSE)

}
\references{
https://en.wikipedia.org/wiki/Trifid_cipher
}
