% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample_cifti.R
\name{resample_cifti}
\alias{resample_cifti}
\alias{resampleCIfTI}
\alias{resamplecii}
\alias{resample_xifti}
\title{Resample CIFTI data}
\usage{
resample_cifti(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  resamp_method = c("barycentric", "adaptive"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

resampleCIfTI(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  resamp_method = c("barycentric", "adaptive"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

resamplecii(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  resamp_method = c("barycentric", "adaptive"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)

resample_xifti(
  x = NULL,
  cifti_target_fname = NULL,
  surfL_original_fname = NULL,
  surfR_original_fname = NULL,
  surfL_target_fname = NULL,
  surfR_target_fname = NULL,
  resamp_res,
  resamp_method = c("barycentric", "adaptive"),
  areaL_original_fname = NULL,
  areaR_original_fname = NULL,
  write_dir = NULL,
  mwall_values = c(NA, NaN),
  verbose = TRUE
)
}
\arguments{
\item{x}{The CIFTI file name or \code{"xifti"} object to resample. If
\code{NULL}, the result will be a \code{"xifti"} with resampled surfaces
given by \code{surfL_original_fname} and \code{surfR_original_fname}.}

\item{cifti_target_fname}{File name for the resampled CIFTI. Will be placed
in \code{write_dir}. If \code{NULL}, will be written to "resampled.d*.nii".
\code{write_dir} will be appended to the beginning of the path.}

\item{surfL_original_fname, surfR_original_fname}{(Optional) Path to a GIFTI
surface geometry file representing the left/right cortex. One or both can be
provided. These will be resampled too, and are convenient for visualizing
the resampled data.

If \code{x} is a \code{"xifti"} object with surfaces, these arguments
will override the surfaces in the \code{"xifti"}.}

\item{surfL_target_fname, surfR_target_fname}{(Optional) File names for the
resampled GIFTI surface geometry files. Will be placed in \code{write_dir}.
If \code{NULL} (default), will use default names created by
\code{\link{resample_cifti_default_fname}}.}

\item{resamp_res}{Target resolution for resampling (number of
cortical surface vertices per hemisphere).}

\item{resamp_method}{\code{"barycentric"} (default) or \code{"adaptive"}
resampling for the metric or label data. These options correspond to the
Workbench command options \code{"BARYCENTRIC"} and \code{"ADAP_BARY_AREA"},
respectively.

While adaptive resampling is recommended for metric or label
data, it requires that \code{area[L/R]_original_fname} be provided.

Note that surfaces will resampled using barycentric resampling regardless of
\code{resamp_method}, because barycentric resampling rather than adaptive
resampling is recommended for surface data.}

\item{areaL_original_fname, areaR_original_fname}{File paths to the surfaces
to use for vertex area correction during adaptive resampling. (Only used if
resampling with the adaptive method.) \code{area[L/R]_original_fname} should
match the current resolution of the data.

For resampling: the Workbench command for adaptive resampling requires the
target surfaces for area correction too. But to make the workflow easier,
\code{ciftiTools} will resample \code{area[L/R]_original_fname} with the
barycentric method and use that for the target area.

For remapping: \code{area[L/R]_target_fname} must be directly provided.}

\item{write_dir}{Where to write the resampled CIFTI (and surfaces if present.)
If \code{NULL} (default), will use the current working directory if \code{x}
was a CIFTI file, and a temporary directory if \code{x} was a \code{"xifti"}
object.}

\item{mwall_values}{If the medial wall locations are not indicated in the
CIFTI, use these values to infer the medial wall mask. Default:
\code{c(NA, NaN)}. If \code{NULL}, do not attempt to infer the medial wall.

Correctly indicating the medial wall locations is important for resampling,
because the medial wall mask is taken into account during resampling
calculations.}

\item{verbose}{Should occasional updates be printed? Default: \code{TRUE}.}
}
\value{
A named character vector of written files: \code{"cifti"} and
potentially \code{"surfL"} (if \code{surfL_original_fname} was provided)
and/or \code{"surfR"} (if \code{surfR_original_fname} was provided).
}
\description{
Performs spatial resampling of CIFTI data on the cortical surface
by separating it into GIFTI and NIFTI files, resampling the GIFTIs, and then
putting them together. (The subcortex is not resampled.)
}
\details{
Can accept a \code{"xifti"} object as well as a path to a CIFTI-file.

If surface data is included, it will be resampled with the barycentric
method even if \code{resamp_method=="adaptive"} because the barycentric
method is recommended for surface geometry data.
}
\section{Connectome Workbench}{

This function interfaces with the \code{"-metric-resample"}, \code{"-label-resample"},
and/or \code{"-surface-resample"} Workbench commands, depending on the input.
}

\seealso{
Other manipulating xifti: 
\code{\link{add_surf}()},
\code{\link{apply_parc}()},
\code{\link{apply_xifti}()},
\code{\link{combine_xifti}()},
\code{\link{convert_xifti}()},
\code{\link{impute_xifti}()},
\code{\link{merge_xifti}()},
\code{\link{move_to_mwall}()},
\code{\link{move_to_submask}()},
\code{\link{newdata_xifti}()},
\code{\link{remap_cifti}()},
\code{\link{remove_xifti}()},
\code{\link{resample_cifti_from_template}()},
\code{\link{scale_xifti}()},
\code{\link{select_xifti}()},
\code{\link{set_names_xifti}()},
\code{\link{smooth_cifti}()},
\code{\link{transform_xifti}()}

Other common: 
\code{\link{is.cifti}()},
\code{\link{read_cifti}()},
\code{\link{smooth_cifti}()},
\code{\link{view_xifti}()},
\code{\link{write_cifti}()}
}
\concept{common}
\concept{manipulating xifti}
