% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_probs_survreg.R
\name{add_probs.survreg}
\alias{add_probs.survreg}
\title{Confidence Intervals for the Survivor Function of Accelerated
Failure Time Models}
\usage{
\method{add_probs}{survreg}(
  df,
  fit,
  q,
  name = NULL,
  yhatName = "median_pred",
  comparison = "<",
  confint = TRUE,
  alpha = 0.05,
  ...
)
}
\arguments{
\item{df}{A data frame of new data.}

\item{fit}{An object of class \code{survreg}. Predictions are made
with this object.}

\item{q}{A double. A quantile of the survival time distribution. In
survival applications this is the time of event.}

\item{name}{\code{NULL} or a string. If \code{NULL}, probabilities
automatically will be named by \code{add_probs()}, otherwise,
the probabilities will be named \code{name} in the returned
data frame.}

\item{yhatName}{A string. Name of the vector of predictions.}

\item{comparison}{A character vector of length one. If
\code{comparison = "<"}, then \eqn{Pr(Y|X < q)} is
calculated. If \code{comparison = ">"}, the survivor function
at time \code{q} is calculated.}

\item{confint}{A logical. If \code{TRUE}, confidence intervals for
the estimated probabilities will be calculated and appended to
\code{df}.}

\item{alpha}{A number. Control the confidence level of the
confidence intervals if \code{confint = TRUE}.}

\item{...}{Additional arguments.}
}
\value{
A dataframe, \code{df}, with predicted medians, probabilities,
    and confidence intervals for predicted probabilities attached.
}
\description{
This function is one of the methods of \code{add_probs} and is
automatically called when an object of class \code{survreg} is
passed to \code{add_probs}.
}
\details{
Confidence intervals may be produced for estimated probabilities of
accelerated failure time models. Presently, confidence intervals
may be computed for lognormal, weibull, exponential, and
loglogistic failure time models. If \code{comparison = "<"},
confidence intervals are made for the probability that a failure
will be observed before \code{q}. Similarly, if \code{comparison =
">"}, confidence intervals will be formed for the probability that
a unit fails after \code{q}. In the survival literature,
\code{comparison = ">"} corresponds to estimating the survivor
function, \emph{S(q)}.

Confidence intervals are produced parametrically via the Delta
Method. Simulations show that under a mild
to moderate amount of censoring, this method performs
adequately.

The logistic transformation is applied to ensure
that confidence interval bounds lie between \eqn{0} and \eqn{1}.

Note: Due to a limitation, the \code{Surv} object must be specified in
\code{survreg} function call. See the examples section for one way
to do this.

Note: \code{add_probs.survreg} cannot inspect the convergence of
\code{fit}. Poor maximum likelihood estimates will result in poor
confidence intervals. Inspect any warning messages given from
\code{survreg}.
}
\examples{
## Define a data set.
df <- survival::stanford2
## remove a covariate with missing values.
df <- df[, 1:4]
## next, create the Surv object inside the survreg call:
fit <- survival::survreg(survival::Surv(time, status) ~ age + I(age^2),
                         data = df, dist = "lognormal")
## Calculate the level 0.75 quantile wit CIs for that quantile
add_probs(df, fit, q = 500, name = c("Fhat", "lwr", "upr"))

## Try a weibull model for the same data:
fit2 <- survival::survreg(survival::Surv(time, status) ~ age + I(age^2),
                          data = df, dist = "weibull")
## Calculate the level 0.75 quantile with CIs for the quantile
add_probs(df, fit2, q = 500, name = c("Fhat", "lwr", "upr"))


}
\references{
For the logistic transformation of estimated probabilities and error bounds:
Meeker, William Q., and Luis A. Escobar. Statistical methods for reliability data. John Wiley & Sons, 2014. (Chapter 8)

For a discussion of forming confidence intervals for survival probabilities:
Harrell, Frank E. Regression modeling strategies. Springer, 2015. (Chapter 17)
}
\seealso{
\code{\link{add_ci.survreg}} for confidence intervals for
    \code{survreg} objects, \code{\link{add_pi.survreg}} for
    prediction intervals of \code{survreg} objects, and
    \code{\link{add_quantile.survreg}} for response quantiles of
    \code{survreg} objects.
}
