% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ciCalibrate.R
\name{plot.supInt}
\alias{plot.supInt}
\title{Plot method for class \code{"supInt"}}
\usage{
\method{plot}{supInt}(x, xlim = x$estimate + c(-1, 1) * 3 * x$se, ...)
}
\arguments{
\item{x}{Object of class \code{"supInt"}}

\item{xlim}{Limits of x-axis}

\item{...}{Other arguments passed to \code{plot}}
}
\value{
Generates a plot of the Bayes factor function with support interval
}
\description{
Plots Bayes factor function and support interval at the specified support level.
}
\examples{
## compute 3 support interval
si3 <- ciCalibrate(ci = c(0.3, 1.5), method = "SI-normal", priorMean = 0,
                   priorSD = 2, siLevel = 3)

## plot Bayes factor function and support interval
plot(si3, xlim = c(0, 1.75))

}
\author{
Samuel Pawel
}
