% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_chemstation_csv.R
\name{read_chemstation_csv}
\alias{read_chemstation_csv}
\title{Read 'Agilent ChemStation' CSV files}
\usage{
read_chemstation_csv(
  path,
  format_out = c("matrix", "data.frame", "data.table")
)
}
\arguments{
\item{path}{Path to 'Agilent' \code{.csv} file.}

\item{format_out}{Class of output. Either \code{matrix}, \code{data.frame},
or \code{data.table}.}
}
\value{
A chromatogram in the format specified by \code{format_out}
(retention time x wavelength).
}
\description{
Reads 'Agilent Chemstation' \code{.csv} files.
}
\details{
'Agilent Chemstation' CSV files are encoded in UTF-16.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
read_chemstation_csv("tests/testthat/testdata/dad1.csv")
\dontshow{\}) # examplesIf}
}
\seealso{
Other 'Agilent' parsers: 
\code{\link{read_agilent_d}()},
\code{\link{read_agilent_dx}()},
\code{\link{read_chemstation_ch}()},
\code{\link{read_chemstation_ms}()},
\code{\link{read_chemstation_reports}()},
\code{\link{read_chemstation_uv}()}
}
\author{
Ethan Bass
}
\concept{'Agilent' parsers}
