% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.covariates.R
\name{add.covariates}
\alias{add.covariates}
\title{add.covariates}
\usage{
add.covariates(interaction.data)
}
\arguments{
\item{interaction.data}{data.table with interaction data. Must contain columns 
\code{bait.id}, \code{target.id}, \code{bait.chr}, \code{bait.start}, 
\code{bait.end}, \code{target.chr}, \code{target.start}, \code{target.end} and \code{count}.}
}
\value{
Updated data table with new columns
\item{bait.trans.count}{number of trans interactions of bait fragment}
	\item{target.trans.count}{number of trans interactions of target fragment}
	\item{distance}{distance between bait and target fragment, or NA if trans}
}
\description{
Add model covariates (trans counts and distance) to an interactions data table.
}
\examples{
	data(bre80);
input.cols <- c('bait.id', 'target.id', 'bait.chr', 'bait.start', 
	'bait.end', 'target.chr', 'target.start', 'target.end', 'count');
output <- add.covariates(bre80[, input.cols, with = FALSE]);

}
\author{
Erle Holgersen <Erle.Holgersen@icr.ac.uk>
}
