#' Cherry Blossom Run data, 2012
#'
#' Details for all 16,924 runners in the 2012 Cherry Blossom Run,
#' which is an annual road race that takes place in Washington, DC.
#'
#' @name run12
#' @docType data
#' @format A data frame with 16,924 observations on the following 9 variables.
#' \describe{
#'   \item{place}{Finishing position. Separate positions are provided for each gender.}
#'   \item{time}{The total run time,, in minutes.}
#'   \item{pace}{Average time per mile, in minutes.}
#'   \item{age}{Age.}
#'   \item{gender}{Gender.}
#'   \item{location}{Hometown city.}
#'   \item{state}{Hometown state (if from the US) or country.}
#'   \item{div_place}{Division place, also broken up by gender.}
#'   \item{div_tot}{Total number of people in the division (again, also split by gender).}
#'   }
#' @source \href{http://www.cherryblossom.org/aboutus/results.php}{Cherry Blossom Race Results}
#' @keywords datasets
#' @examples
#'
#' library(ggplot2)
#'
#' # Finishing times
#' ggplot(run12, aes(x = time)) +
#'   geom_histogram(binwidth = 5) +
#'   labs(
#'     title = "Finishing times for 2012 Cherry Blossom Run,",
#'     x = "Time to complete the race, in minutes",
#'     y = "Frequency"
#'     )
#'
#' # Pacing
#' ggplot(run12, aes(x = pace)) +
#'   geom_histogram(binwidth = 0.5) +
#'   labs(
#'     title = "Pacing for 2012 Cherry Blossom Run",
#'     x = "Average time per mile, in minutes",
#'     y = "Frequency"
#'     )
#'
"run12"
