# WARNING - Generated by {fusen} from dev/flat_check_clean_userspace.Rmd: do not edit by hand

test_that("check_clean_userspace works", {
  if (!interactive()) {
    skip_on_os("windows")
    skip_on_os("mac")
  }

  path <- suppressWarnings(create_example_pkg())
  dir.create(file.path(path, "tests", "testthat"), recursive = TRUE)
  # Add a test that let file in the testthat dir
  cat(
    "cat('#in tests', file = 'in_test.R')",
    file = file.path(path, "tests", "testthat", "test-in_test.R")
  )

  # Add an example that let file in tempdir
  cat(
    "#' Function",
    "#' @return 1",
    "#' @export",
    "#' @examples",
    "#' text <- \"in_example\"",
    "#' file <- tempfile(\"in_example\")",
    "#' cat(text, file = file)",
    "in_example <- function() {",
    "1",
    "}",
    sep = "\n",
    file = file.path(path, "R", "in_example.R")
  )

  # Add a vignette that let file in local ?

  suppressWarnings(attachment::att_amend_desc(path = path))

  check_output <- tempfile("check_output")
  scratch_dir <- tempfile("dirtmp")

  # debugonce(check_clean_userspace)
  expect_warning(
    expect_message(
      all_files <- check_clean_userspace(pkg = path, check_output = check_output),
      "Some files"
    ),
    "One of the 'Run examples'"
  )

  if (nrow(all_files) == 5) {
    # In some cases, the check updates the DESCRIPTION file as it run document()
    expect_equal(all_files$source, c(
      "Unit tests", "Unit tests", "Run examples", "Run examples",
      "Full check"
    ))
    expect_equal(all_files$problem, c("added", "added", "added", "added", "added"))
    expect_equal(
      normalizePath(all_files$where, winslash = "/"),
      normalizePath(c(path, rep(tempdir(), 4)), winslash = "/")
    )
    expect_true(all(grepl("in_test[.]R", all_files$file[1:2])))
    expect_true(any(grepl("in_example", all_files$file[3:4]))) # One of the two
    expect_true(any(grepl("DESCRIPTION$", all_files$file[5])))
  } else if (nrow(all_files) == 6) {
    # In some cases, the check updates the DESCRIPTION file as it run document()
    expect_equal(all_files$source, c(
      "Unit tests", "Unit tests", "Run examples", "Run examples",
      "Full check", "Full check"
    ))
    expect_equal(all_files$problem, c("added", "added", "added", "added", "added", "added"))
    expect_equal(
      normalizePath(all_files$where, winslash = "/"),
      normalizePath(c(path, rep(tempdir(), 5)), winslash = "/")
    )
    expect_true(all(grepl("in_test[.]R", all_files$file[1:2])))
    expect_true(any(grepl("in_example", all_files$file[3:4]))) # One of the two
    expect_true(any(grepl("DESCRIPTION$", all_files$file[5])))
    expect_true(any(grepl("symbols[.]rds$", all_files$file[6])))
  } else if (nrow(all_files) == 11) {
    expect_equal(all_files$source, c(
      "Unit tests", "Unit tests", "Run examples", "Run examples",
      "Full check", "Full check", "Full check", "Full check", "Full check",
      "Full check", "Full check"
    ))
    expect_equal(all_files$problem, c(
      "added", "added", "added", "added", "added", "added", "added",
      "added", "added", "added", "added"
    ))
    expect_equal(
      all_files$where,
      gsub(
        file.path("/private", c(path, rep(tempdir(), 10)), fsep = ""),
        pattern = "//",
        replacement = "/"
      )
    )
    expect_true(all(grepl("in_test[.]R", all_files$file[1:2])))
    expect_true(any(grepl("in_example", all_files$file[3:4]))) # One of the two
    expect_true(any(grepl("callr-", all_files$file[5:8])))
    expect_true(any(grepl("DESCRIPTION$", all_files$file[9])))
    expect_true(any(grepl("foo[.]o", all_files$file[10])))
    expect_true(any(grepl("symbols[.]rds", all_files$file[11])))
  } else {
    stop("Number of rows is not expected: ", all_files)
  }

  unlink(path, recursive = TRUE)
  unlink(check_output, recursive = TRUE)
  unlink(scratch_dir, recursive = TRUE)
})
