% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.R
\name{as.character.checkglobals}
\alias{as.character.checkglobals}
\title{Cast to character}
\usage{
\method{as.character}{checkglobals}(x, pattern, which = c("global", "import"), ...)
}
\arguments{
\item{x}{object inheriting from class \code{"checkglobals"}.}

\item{pattern}{an optional \link{regular expression}.  Only names
matching \code{pattern} are returned. \code{\link{glob2rx}} can be
used to convert wildcard patterns to regular expressions.}

\item{which}{a character vector, either \code{"global"} to print all unrecognized global variables,
\code{"import"} to print all detected imported functions and variables, or both (default).}

\item{...}{additional arguments to configure the output:
\itemize{
\item \code{all.names}, a logical value.  If \code{TRUE}, all object names are returned.
If \code{FALSE}, names which begin with a \samp{.} are omitted. Defaults to \code{TRUE}.
\item \code{sorted}, a logical value indicating if the function/variable names should be sorted alphabetically.
Defaults to \code{TRUE}.
}}
}
\value{
a character vector containing the names of the global or imported function/variables.
}
\description{
Cast an S3-object of class \code{"checkglobals"} to a character vector.
}
\examples{
## R-package from folder
chk <- checkglobals(
  pkg = system.file(
    "unit_tests", "pkg", "testpkg",
    package = "checkglobals"
  )
)
as.character(chk)

## include only imports
as.character(chk, which = "import")
}
\seealso{
\code{\link{as.character}}
}
