% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chatLLM.R
\name{list_models}
\alias{list_models}
\title{List Available Models for Supported Providers}
\arguments{
\item{provider}{Character. One of \code{"github"}, \code{"openai"},
\code{"groq"}, \code{"anthropic"}, \code{"deepseek"},
\code{"dashscope"}, \code{"azure_openai"}, \code{"azure_foundry"},
\code{"bedrock"} or \code{"all"}.
Case - insensitive.}

\item{...}{Additional arguments passed to the per - provider helper
(e.g. \code{limit} for Anthropic, or \code{api_version} for GitHub).}

\item{github_api_version}{Character. Header value for
\code{X - GitHub - Api - Version} (GitHub Models). Default \code{"2022 - 11 - 28"}.}

\item{anthropic_api_version}{Character. Header value for
\code{anthropic - version} (Anthropic). Default \code{"2023 - 06 - 01"}.}

\item{azure_api_version}{Character. Query version for Azure OpenAI listing.
Default \code{"2024-02-15-preview"}.}

\item{azure_foundry_api_version}{Character. Query version for Azure AI Foundry
model listing. Default \code{"2024-05-01-preview"}.}
}
\value{
If \code{provider != "all"}, a character vector of model IDs for that
single provider. If \code{provider == "all"}, a named list of character
vectors, one per provider.
}
\description{
Retrieve the catalog of available model IDs for one or all supported
chat - completion providers. Useful for discovering active models and
avoiding typos or deprecated defaults.

Supported providers:
\itemize{
  \item \code{"openai"}     -  OpenAI Chat Completions API
  \item \code{"groq"}       -  Groq OpenAI - compatible endpoint
  \item \code{"anthropic"}  -  Anthropic Claude API
  \item \code{"deepseek"}   -  DeepSeek chat API
  \item \code{"dashscope"}  -  Alibaba DashScope compatible API
  \item \code{"github"}     -  GitHub Models OpenAI - compatible API
  \item \code{"azure_openai"} - Azure OpenAI deployments/models
  \item \code{"azure_foundry"} - Azure AI Foundry chat/models endpoints
  \item \code{"bedrock"}    -  AWS Bedrock (Converse API)
  \item \code{"all"}        -  Fetch catalogs for all of the above
}
}
\examples{
\dontrun{
Sys.setenv(OPENAI_API_KEY = "sk-...")
openai_models <- list_models("openai")
head(openai_models)

Sys.setenv(ANTHROPIC_API_KEY = "sk-...")
anthro_models <- list_models("anthropic", anthropic_api_version = "2023-06-01")

Sys.setenv(GH_MODELS_TOKEN = "ghp-...")
github_models <- list_models("github", github_api_version = "2022-11-28")
}

}
\seealso{
\code{\link{call_llm}}
}
