% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TextSummary.R
\name{TextSummary}
\alias{TextSummary}
\title{Summarize Long Text}
\usage{
TextSummary(
  text = clipr::read_clip(),
  nch = 2000,
  verbose = TRUE,
  returnText = FALSE
)
}
\arguments{
\item{text}{A character vector containing the text to be summarized.
If not provided, the function will attempt to read from the clipboard.}

\item{nch}{Integer specifying the number of characters at which to split the input text for processing.}

\item{verbose}{A logical flag to print the message. Default is TRUE.}

\item{returnText}{A logical flag to return summarized text results. Default is FALSE.}
}
\value{
The summarized text is placed into the clipboard and the function returns the result of \code{clipr::write_clip}.
}
\description{
This function summarizes a long text using LLM.
   The development of this function started with the idea that it might be interesting
   to perform a copy-and-paste, sentence summarization and aims to be an evangelist for
   copy-and-paste LLM execution. It is recommended to run this function with GPT-4, but it is not cost effective and slow.
   This is still an experimental feature.
}
\details{
Summarize Long Text
}
\examples{
\dontrun{
TextSummary(text = c("This is a long text to be summarized.",
                     "It spans multiple sentences and goes into much detail."),
            nch = 10)
}
}
\author{
Satoshi Kume
}
