% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariate_polynomial.R
\name{DP.poly}
\alias{DP.poly}
\title{Dynamic programming algorithm for univariate polynomials change points detection.}
\usage{
DP.poly(y, r, gamma, delta)
}
\arguments{
\item{y}{A \code{numeric} vector of observations.}

\item{r}{An \code{integer} scalar order of polynomials.}

\item{gamma}{A \code{numeric} scalar of the tuning parameter associated with the \eqn{l_0} penalty.}

\item{delta}{A strictly \code{integer} scalar of minimum spacing.}
}
\value{
A \code{list} with the following structure:

An object of \code{\link[base]{class}} "DP", which is a \code{list} with the following structure:
 \item{partition}{A vector of the best partition.}
 \item{yhat}{A vector of mean estimation for corresponding to the best partition.}
 \item{cpt}{A vector of change points estimation.}
}
\description{
Perform dynamic programming algorithm for univariate polynomials change points detection.
}
\examples{
set.seed(0)
cpt_true = c(20, 50, 170)
y = rnorm(300) + c(rep(0,20),rep(2,30),rep(0,120),rep(2,130))
plot.ts(y)
temp = DP.poly(y, r = 2, gamma = 15, delta = 5)
temp$cpt
}
\references{
Yu and Chatterjee (2020) <arXiv:2007.09910>
}
\author{
Haotian Xu
}
