% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HD_regression.R
\name{CV.search.DPDU.regression}
\alias{CV.search.DPDU.regression}
\title{Grid search based on cross-validation of dynamic programming for regression change points localisation with \eqn{l_0} penalisation.}
\usage{
CV.search.DPDU.regression(y, X, lambda_set, zeta_set, eps = 0.001)
}
\arguments{
\item{y}{A \code{numeric} vector of response variable.}

\item{X}{A \code{numeric} matrix of covariates with vertical axis being time.}

\item{lambda_set}{A \code{numeric} vector of candidate tuning parameters for lasso penalty.}

\item{zeta_set}{An \code{integer} vector of tuning parameter associated with \eqn{l_0} penalty (minimum interval size).}

\item{eps}{A \code{numeric} scalar of precision level for convergence of lasso.}
}
\value{
A \code{list} with the following structure:
 \item{cpt_hat}{A list of vectors of estimated change points}
 \item{K_hat}{A list of scalars of number of estimated change points}
 \item{test_error}{A matrix of testing errors (each row corresponding to each gamma, and each column corresponding to each lambda)}
 \item{train_error}{A matrix of training errors}
 \item{beta_hat}{A list of matrices of estimated regression coefficients}
}
\description{
Perform grid search to select tuning parameters gamma (for \eqn{l_0} penalty of DP) and lambda (for lasso penalty) based on cross-validation.
}
\examples{
d0 = 5
p = 30
n = 200
cpt_true = 100
data = simu.change.regression(d0, cpt_true, p, n, sigma = 1, kappa = 9)
lambda_set = c(0.01, 0.1, 1, 2)
zeta_set = c(10, 15, 20)
temp = CV.search.DPDU.regression(y = data$y, X = data$X, lambda_set, zeta_set)
temp$test_error # test error result
# find the indices of lambda_set and zeta_set which minimizes the test error
min_idx = as.vector(arrayInd(which.min(temp$test_error), dim(temp$test_error))) 
lambda_set[min_idx[2]]
zeta_set[min_idx[1]]
cpt_init = unlist(temp$cpt_hat[min_idx[1], min_idx[2]])
beta_hat = matrix(unlist(temp$beta_hat[min_idx[1], min_idx[2]]), ncol = length(cpt_init)+1)
}
\references{
Xu, Wang, Zhao and Yu (2022) <arXiv:2207.12453>.
}
\author{
Haotian Xu
}
