% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encode.R
\name{cereal_encode}
\alias{cereal_encode}
\title{Encode a vector as JSON}
\usage{
cereal_encode(x)
}
\arguments{
\item{x}{A vector}
}
\value{
A list that can be converted to JSON with \code{\link[jsonlite:fromJSON]{jsonlite::toJSON()}}
}
\description{
Create a list encoding the vctrs prototype (metadata) that can be stored
as JSON.
}
\details{
Use the \code{digits} option to specify how many digits after the decimal point
to record in JSON, for example via \code{\link[withr:with_options]{withr::local_options()}}.
}
\examples{
cereal_encode(1:10)
cereal_encode(Sys.Date())
cereal_encode(sample(letters, 5))
cereal_encode(factor(letters[1:5], labels = "letter"))
cereal_encode(factor(LETTERS[3:1], ordered = TRUE))

## you can encode a ptype as well:
ptype <- vctrs::vec_ptype(factor(LETTERS[3:1], ordered = TRUE))
## but "example" is NULL:
cereal_encode(ptype)

}
\seealso{
\code{\link[vctrs:vec_ptype]{vctrs::vec_ptype()}}, \code{\link[=cereal_decode]{cereal_decode()}}
}
