% Generated by roxygen2 (4.0.2): do not edit by hand
\name{markovcent}
\alias{markovcent}
\title{Find the markov centrality score}
\usage{
markovcent(graph, vids = V(graph))
}
\arguments{
\item{graph}{The input graph as igraph object}

\item{vids}{Vertex sequence, the vertices for which the markov centrality values are returned.}
}
\value{
A numeric vector contaning the centrality scores for the selected vertices.
}
\description{
The Markov centrality score uses the concept of a random walk through the graph to calculate the centrality of each vertex.
}
\details{
The method uses the mean first-passage time from every vertex to every other vertex to produce a score for each vertex. \cr
More detail at \href{http://www.centiserver.org/?q1=centrality&q2=Markov_Centrality}{Markov Centrality}
}
\examples{
g <- graph(c(1,2,2,3,3,4,4,2))
markovcent(g)
}
\author{
Mahdi Jalili \email{m_jalili@farabi.tums.ac.ir}

Original code from Bioconductor SANTA package (Cornish AJ, 2014)
}
\references{
White, S. & Smyth, P. Algorithms for estimating relative importance in networks. Proceedings of the ninth ACM SIGKDD international conference on Knowledge discovery and data mining, 2003. ACM, 266-275.

Cornish AJ and Markowetz F (2014). "SANTA: Quantifying the Functional Content of Molecular Networks." PLOS Computational Biology, 10(9), pp. e1003808. http://dx.doi.org/10.1371/journal.pcbi.1003808.
}

