% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.int.R
\name{gen.int}
\alias{gen.int}
\title{Consistent Estimation of the Number of Communities via Regularized Network Embedding.}
\usage{
gen.int(A, R=8, K.max0=8,rand.seed=123,
               lambda3=0, a=3, kappa=1, alpha=1,
               eps = 1e-2, niter = 20, niter.Z=5)
}
\arguments{
\item{A}{An observed n * n adjacency matrix of undirected graph.}

\item{R}{Int, the relatively large dimension of embedding vectors given in advance.}

\item{K.max0}{The relatively large upper bound of the number of communities given in advance to generate initial values of B.}

\item{rand.seed}{The random seed of generating initial value.}

\item{lambda3}{A float value, the tuning parameter for sparsity of Z.}

\item{a}{A float value, regularization parameter in MCP, the default setting is 3.}

\item{kappa}{A float value, the penalty parameter in ADMM algorithm, the default setting is 1.}

\item{alpha}{A float value, the step size of coordinate descent algorithm updating Z, the default setting is 1.}

\item{eps}{A float value, algorithm termination threshold.}

\item{niter}{Int, maximum number of cycles of the overall ADMM algorithm.}

\item{niter.Z}{Int, maximum number of cycles of coordinate descent algorithm updating Z.}
}
\value{
A list including all estimated parameters and the BIC values with all choices of given tuning parameters, and the selected optional parameters.
Opt_Z: A n * r matrix, the estimated embedding vectors corresponding to n nodes;
Opt_B: A n * r matrix, the estimated community centers corresponding to n nodes;
Opt_K: Int, the estimated number of communities;
Opt_member: A n-dimensional vector, describing the membership of n nodes;
Opt_cluster.matrix: A n * n membership matrix, whose (i,j)-element is 1, if nodes i and j belong to the same community, and 0, otherwise.
}
\description{
The function generating the initial values.
}
\examples{
library(cencrne)
data(example.data)
A                   = example.data$A
K.true              = example.data$K.true
Z.true              = example.data$Z.true
B.true              = example.data$B.true
P.true              = example.data$P.true
Theta.true          = example.data$Theta.true
cluster.matrix.true = example.data$cluster.matrix.true

n              = dim(A)[1]
sample.index.n = rbind(combn(n,2),1:(n*(n-1)/2))
int.list       = gen.int(A)
Z.int          = int.list$Z.int
B.int          = int.list$B.int



}
\references{
Ren, M., Zhang S., Zhang Q. and Ma S. (2022). Consistent Estimation of the Number of Communities via Regularized Network Embedding.
}
\author{
Mingyang Ren.
}
