% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track-set-transformations.R
\name{projectDimensions}
\alias{projectDimensions}
\title{Extract Spatial Dimensions}
\usage{
projectDimensions(x, dims = c("x", "y"))
}
\arguments{
\item{x}{the input tracks object.}

\item{dims}{a character vector (for column names) or an integer vector (for column
indices) giving the dimensions to extract from each track.
The time dimension (i.e., the first column of all tracks) is always included.}
}
\value{
A tracks object is returned that contains only those dimensions
of the input \code{tracks} that are given in \code{dims}.
}
\description{
Projects tracks onto the given spatial dimensions.
}
\examples{
## Compare 2D and 3D speeds
load( system.file("extdata", "TCellsRaw.rda", package="celltrackR" ) )
speed.2D <- mean( sapply( subtracks( projectDimensions( TCellsRaw, c("x","z") ), 2 ), speed ) )
speed.3D <- mean( sapply( TCellsRaw, speed ) )

}
