% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getCDL.R
\name{getCDL}
\alias{getCDL}
\title{Get CDL raster data}
\usage{
getCDL(
  x,
  year,
  alternativeUrl,
  location = tempdir(),
  https = TRUE,
  ssl.verifypeer = TRUE,
  returnType = "raster"
)
}
\arguments{
\item{x}{Is either a two digit state FIPS code, a two letter abbreviation, or
a state name.}

\item{year}{A numerical vector. A set of years of CDL data to download.}

\item{alternativeUrl}{An optional string containing an alternative url.}

\item{location}{An optional string containing a folder to store the file.  If no folder is given, the R temporary directory will be used.}

\item{https}{Legacy https flag, all traffic uses https, if you need http provide alternative url.}

\item{ssl.verifypeer}{An optional boolean to turn on and off ssl verfication, default is on.}

\item{returnType}{An optional parameter to select to return either 'raster' or 'terra' based raster files.}
}
\value{
A list of CDL raster objects of interested county for a set of years.  Note that this is a generic list allowing for rasters with different extents and resolutions.
}
\description{
\code{getCDL} retrieves CDL state raster objects for a set of years.
}
\examples{
\dontrun{
# Get data for California, 2013 and 2015
# by FIPS
getCDL(6,c(2013,2015))
# Get data for California, 2013 and 2015 with Terra
getCDL("California",c(2013,2015), returnType='terra')
# Get all the west coast from 2009 to 2016
getCDL(c("CA","OR","WA"),2013:2016)
}
}
\author{
Jonathan Lisic, \email{jlisic@gmail.com}

Jemma Stachelek, \email{stachel2@msu.edu}
}
