% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfquantregFT.R
\name{cdfquantregFT}
\alias{cdfquantregFT}
\title{CDF-Quantile Finite Tailed Probability Distributions}
\usage{
cdfquantregFT(
  formula,
  fd = NULL,
  sd = NULL,
  mu.fo = NULL,
  inner = FALSE,
  version = "V",
  data,
  family = NULL,
  start = NULL,
  ssn = 20,
  control = cdfqr.control(...),
  ...
)
}
\arguments{
\item{formula}{A formula object, with the dependent variable (DV) on the left of an ~ operator, and predictors on the right. For the part on the right of '~', the specification of the dispersion (sigma; first) and skewness (theta; second) submodels can be separated by '|'. So \code{y ~ X1 | X2} specifies that the DV is \code{y}, \code{X1} is the predictor in the dispersion submodel, and \code{X2} is the predictor in the skewness submodel.}

\item{fd}{A string that specifies the parent distribution. At the moment, only "arcsinh", "cauchit" and "t2" can be used. See details.}

\item{sd}{A string that specifies the child distribution. At the moment, only "arcsinh", "cauchy" and "t2" can be used. See details.}

\item{mu.fo}{A formula object to indicate the predictors for the location submodel if the 3-parameter distribution is used, only input as \code{~ predictors}}

\item{inner}{A logic value that indicates if the inner (\code{inner = TRUE}) case or outer (\code{inner = FALSE}) will be used. Currently inner case can only be used for 2-parameter distributions.}

\item{version}{A string indicates that which version will be used. "V" is the tilt transformation while "W" indicates the Jones Pewsey transformation.}

\item{data}{The data in a data.frame format}

\item{family}{If `fd` and `sd` are not provided, the name of a member of the family of distributions can be provided (see below) for details of family functions)}

\item{start}{The starting values for model fitting. If not provided, default values will be used.}

\item{ssn}{The number of searches on optimal starting values to be performed. If model does not converge, can increase this number.}

\item{control}{Control optimization parameters  (See \code{\link{cdfqr.control}}))}

\item{...}{Currently ignored.}
}
\value{
An object of class \code{cdfqrFT} will be returned. Generic functions such as \link{summary},\link{print} and \link{coef} can be used to extract output (see \link{summary.cdfqr} for more details about the generic functions that can be used).
Class of object is a list with the following output:
 \describe{
  \item{coefficients}{A named vector of coefficients.}
  \item{residuals}{Raw residuals, the difference between the fitted values and the data.}
  \item{fitted}{The fitted values, including full model fitted values, fitted values for the mean component, and fitted values for the dispersion component.}
  \item{rmse}{The model root mean squared errors}
  \item{rmseLogit}{The root mean squared errors between the logit of the fitted values, and the logit of the response values.}
  \item{vcov}{The variance-covariance matrix of the coefficient estimates.}
  \item{AIC, BIC}{Akaike's Information Criterion and Bayesian Information Criterion.}
  \item{deviance}{The deviance for the model.}
}
}
\description{
\code{cdfquantregFT} is a function to fit a cdf quantile regression with a variety of finite tailed distributions. It can account for data that has boundary values.
}
\details{
The cdfquantregFT function fits a quantile regression model with a distributions from the cdf-quantile finite tailed distributions. 
Here is the list of currently available distributions.

\bold{Bimodal Shape Distributions}
  \tabular{lllcc}{
  \bold{Distribution}  \tab \bold{R input} \tab \bold{Alternative Input}  \tab \bold{Available Version}\cr
  ArcSinh-ArcSinh	\tab \code{fd = "arcsinh", sd = "arcsinh"}	\tab \code{family = "arcsinh-arcsinh"} \tab	\code{"V", "W"}	\cr
  ArcSinh-Cauchy	\tab \code{fd = "arcsinh", sd = "cauchy"}	\tab \code{family = "arcsinh-cauchy"} \tab	\code{"V", "W"}	\cr
  Cauchit-ArcSinh	\tab \code{fd = "cauchit", sd = "arcsinh"}	\tab \code{family = "cauchit-arcsinh"} \tab	\code{"V", "W"}	\cr
  Cauchit-Cauchy	\tab \code{fd = "cauchit", sd = "cauchy"}	\tab \code{family = "cauchit-cauchy"} \tab	\code{"V", "W"}	\cr
  T2-T2	\tab \code{fd = "t2", sd = "t2"}	\tab \code{family = "t2-cauchy"} \tab	\code{"V", "W"}	\cr
  }
}
\examples{
data(cdfqrExampleData)
fit <- cdfquantregFT(pnurse ~ Ambulance |Ambulance ,
 fd = "arcsinh", sd = "arcsinh",  inner = FALSE, version = "V", data = yoon)
summary(fit)
}
