% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ptmean.R
\name{ptmean}
\alias{ptmean}
\title{Cumulative distribution function for t distribution}
\usage{
ptmean(q, mean, s2, n)
}
\arguments{
\item{q}{coordinate at which the cdf is to be evaluated (named in accordance with R standards)}

\item{mean}{the assumed normal mean}

\item{s2}{the observed sample variance (pass this as an extra argument to cdfinv())}

\item{n}{the sample size (pass this as an extra argument to cdfinv())}
}
\value{
The quantile of the t distribution for n-1 degrees of freedom corresponding to the input value of the sample mean.
}
\description{
Computes the quantile of the t distribution for n-1 degrees of freedom corresponding to the input value of the sample mean.
}
\details{
Do not call ptmean() directly.
Pass DISTR="tmean" to cdfinv() when computing intervals for the
normal mean when the variance is unknown.
The parameter name to be passed to cdfinv() is mean.
The additional arguments s2 (sample variance) and
n (sample size) are to be passed to cdfinv().
}
\examples{
cdfinv("tmean","mean",14.35,s2=4.5,n=22) ## returns 13.40946 15.29054
}
\author{
Peter E. Freeman, \email{pfreeman@cmu.edu}
}
