% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flim.R
\name{flim}
\alias{flim}
\title{Forest Light Interaction Model (FLIM)}
\usage{
flim(Rc, Rg, To = NULL, Ts = NULL, params, area = 10000)
}
\arguments{
\item{Rc}{Canopy reflectance at infinite depth}

\item{Rg}{soil/background reflectance}

\item{To}{transmission in viewing direction}

\item{Ts}{transmission in sun direction}

\item{params}{a named vector of parameters: 
 \itemize{
\item [1] = D, stand density (confounded with cd)
\item [2] = cd, crown diameter (confounded with D)
\item [3] = h, mean crown height
\item [6] = Solar zenith angle (tts)
\item [7] = Observer zenith angle (tto)
\item [8] = Sun-sensor azimuth angle (psi)
}}

\item{area}{area of stand}
}
\value{
a list with reflectance, and the fractions of shaded 
and sunexplosed crowns, shaded and sun exposed open space.
}
\description{
The FLIM model was first described by Rosema et al (1992).
In FLIM forests are assumed a discontinous mix of tree crowns
and gaps. Reflectance is modelled in terms of the
probabilty to observe either a gap (background)
or a tree crown. Both gaps and crowns may be shaded.
}
\details{
Confounded parameters pairs cannot be inversely
estimated, one of the pairs should be set to 1.
}
\references{
Rosema, A., Verhoef, W., Noorbergen, H., Borgesius, J.J. (1992). 
A new forest light interaction model in support of forest monitoring. 
Remote Sens. Environ. 42, 23-41.
}
