% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_ctx.R
\name{register_ccdr}
\alias{register_ccdr}
\alias{showing_key}
\alias{ccdr_show_api_key}
\alias{ccdr_hide_api_key}
\alias{print.ctx_credentials}
\alias{ctx_key}
\alias{has_ctx_key}
\title{Register a CTX API}
\usage{
showing_key()

ccdr_show_api_key()

ccdr_hide_api_key()

register_ccdr(key, write = FALSE)

\method{print}{ctx_credentials}(...)

ctx_key()

has_ctx_key()
}
\arguments{
\item{key}{an API key}

\item{write}{if TRUE, stores the secrets provided in the .Renviron file}

\item{...}{a dumped formal argument to the generic print method}
}
\value{
\itemize{
\item \code{showing_key} returns a Boolean.
\item \code{ccdr_show_api_key()} has no return value but has the side effect of
changing the display settings of the API key.
\item \code{ccdr_hide_api_key()} has no return value but has the side effect of
changing the display settings of the API key.
\item \code{register_ccdr()} has no return value but has the side effect of
storing the API key.
\item \code{print.ctx_credentials()} has no return value and is an S3 method for
printing the \code{ctx_credentials} class.
\item \code{ctx_key()} returns a string, either the stored API key or
\code{NA_character_}.
\item \code{has_ctx_key()} returns a Boolean.
}
}
\description{
This page contains documentation tools related to enabling CTX API services
in R.
}
\details{
To obtain an API key and enable services, go to
\url{https://www.epa.gov/comptox-tools/computational-toxicology-and-exposure-apis}.
This documentation shows you how to obtain an API key to allow access to the
CTX APIs.

To tell ccdR about your API key, use \code{\link[=register_ccdr]{register_ccdr()}}, e.g.
\code{register_ccdr(key = 'grbwigbwoginrowgbwibgdibdvinrginiwgo')} (that's a fake
key). This will set your API key for the current session, but if you restart
R, you'll need to do it again. You can set it permanently by setting \code{write = TRUE}m see the examples. If you set it permanently it will be stored in a
local file, and that will be accessed by ccdR persistently across
sessions.

Users should be aware that the API key, a string of garbled
characters/numbers/symbols, is a PRIVATE key - it uniquely identifies and
authenticates you to CTX's services. If anyone gets your API key, they can
use it to masquerade as you to CTX. To mitigate against users inadvertently
sharing their keys, by default ccdR never displays a user's key in messages
displayed to the console.

Users should be aware that ccdR has no mechanism with which to safeguard the
private key once registered with R. That is to say, once you register your
API key, any R function will have access to it. As a consequence, ccdR will
not know if another function, potentially from a compromised package,
accesses the key and uploads it to a third party. For this reason, when using
ccdR we recommend a heightened sense of security and self-awareness: only use
trusted packages, do not save the API keys in script files, etc.
}
\examples{
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check if API key is showing
showing_key()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Toggle API key to display
ccdr_show_api_key()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Toggle API key to be hidden
ccdr_hide_api_key()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Register key for this session
register_ccdr(key = 'YOUR API KEY')
# Register key over sessions
register_ccdr(key = 'YOUR API KEY', write = TRUE)
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Print function for ctx_credentials class
print.ctx_credentials()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Display ctx API key
ctx_key()
\dontshow{\}) # examplesIf}
\dontshow{if (has_ctx_key() & is.na(ctx_key() == 'FAKE_KEY')) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Check whether API key is registered
has_ctx_key()
\dontshow{\}) # examplesIf}
}
