% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genomics_by_sample.R
\name{get_fusions_by_sample}
\alias{get_fusions_by_sample}
\alias{get_structural_variants_by_sample}
\title{Get Fusions By Sample ID}
\usage{
get_fusions_by_sample(
  sample_id = NULL,
  study_id = NULL,
  molecular_profile_id = NULL,
  sample_study_pairs = NULL,
  genes = NULL,
  panel = NULL,
  base_url = NULL
)

get_structural_variants_by_sample(
  sample_id = NULL,
  study_id = NULL,
  molecular_profile_id = NULL,
  sample_study_pairs = NULL,
  genes = NULL,
  panel = NULL,
  base_url = NULL
)
}
\arguments{
\item{sample_id}{a vector of sample IDs (character)}

\item{study_id}{A string indicating the study ID from which to pull data. If no study ID, will
guess the study ID based on your URL and inform. Only 1 study ID can be passed. If mutations/cna from
more than 1 study needed, see \code{sample_study_pairs}}

\item{molecular_profile_id}{A string indicating the molecular profile ID from which to pull data. If ID supplied, will
guess the molecular profile ID based on the study ID. Only 1 molecular profile ID can be passed. If mutations from
more than 1 study needed, see \code{sample_study_pairs}}

\item{sample_study_pairs}{A dataframe with columns: \code{sample_id}, \code{study_id} and \code{molecular_profile_id} (optional). Variations in capitalization of column names are accepted.
This can be used in place of \code{sample_id}, \code{study_id}, \code{molecular_profile_id} arguments above if you
need to pull samples from several different studies at once. If passed this will take overwrite \code{sample_id}, \code{study_id}, \code{molecular_profile_id} if also passed.}

\item{genes}{A vector of Entrez ids or Hugo symbols. If Hugo symbols are supplied, they will be converted to entrez ids using the \code{get_entrez_id()} function.
If \code{panel} and \code{genes} are both supplied, genes from both arguments will be returned. If both are NULL (default), it will return gene results for all available genomic data for that sample.}

\item{panel}{One or more panel IDs to query (e.g. 'IMPACT468').
If \code{panel} and \code{genes} are both supplied, genes from both arguments will be returned. If both are NULL (default), it will return gene results for all available genomic data for that sample.}

\item{base_url}{The database URL to query
If \code{NULL} will default to URL set with \verb{set_cbioportal_db(<your_db>)}}
}
\value{
A data frame of Fusions
}
\description{
Get Fusions By Sample ID
}
\examples{
\dontrun{
set_cbioportal_db("public")

#' # These return the same results
get_fusions_by_sample(sample_id = c("s_C_CAUWT7_P001_d"),
                 study_id = "prad_msk_2019")
get_structural_variants_by_sample(sample_id = c("s_C_CAUWT7_P001_d"),
                 study_id = "prad_msk_2019")
                 }
}
