% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpu.R
\name{manhattan_distance_matrix_gpu}
\alias{manhattan_distance_matrix_gpu}
\title{Compute Pairwise Manhattan Distance Matrix on GPU}
\usage{
manhattan_distance_matrix_gpu(states1, states2, batch_size = 256L)
}
\arguments{
\item{states1}{Numeric matrix (N1 x n), first set of states}

\item{states2}{Numeric matrix (N2 x n), second set of states}

\item{batch_size}{Integer, number of states2 rows to process at once
(default 256)}
}
\value{
Numeric matrix (N1 x N2) of Manhattan distances
}
\description{
Computes all pairwise Manhattan distances between two sets of states.
Returns an N1 x N2 matrix where entry (i,j) is the Manhattan distance
between row i of states1 and row j of states2.
}
\details{
For large matrices, computation is batched over columns of the result
to avoid GPU memory overflow.
}
\examples{
\donttest{
if (cayley_gpu_available()) {
  s1 <- matrix(c(1,2,3,4,5, 5,4,3,2,1), nrow = 2, byrow = TRUE)
  s2 <- matrix(c(3,3,3,3,3, 1,1,1,1,1), nrow = 2, byrow = TRUE)
  manhattan_distance_matrix_gpu(s1, s2)
}
}
}
