% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_path_iterative.R
\name{find_path_iterative}
\alias{find_path_iterative}
\title{Iterative Path Finder Between Permutation States}
\usage{
find_path_iterative(
  start_state,
  final_state,
  k,
  moves = c("1", "2", "3"),
  combo_length = 20,
  n_samples = 200,
  n_top = 10,
  max_iterations = 10,
  potc = 1,
  ptr = 10,
  opd = FALSE,
  reuse_combos = FALSE,
  distance_method = "manhattan",
  verbose = TRUE
)
}
\arguments{
\item{start_state}{Integer vector, the starting permutation state}

\item{final_state}{Integer vector, the target permutation state}

\item{k}{Integer, parameter for reverse operations}

\item{moves}{Character vector, allowed operations (default c("1", "2", "3"))}

\item{combo_length}{Integer, length of random operation sequences (default 20)}

\item{n_samples}{Integer, number of random sequences to test per iteration (default 200)}

\item{n_top}{Integer, number of top sequences to analyze fully (default 10)}

\item{max_iterations}{Integer, maximum number of search iterations (default 10)}

\item{potc}{Numeric in (0,1], fraction of cycle states to keep (default 1)}

\item{ptr}{Integer, max intersections to process per iteration (default 10)}

\item{opd}{Logical, if TRUE filters states to only combos containing bridge state (default FALSE)}

\item{reuse_combos}{Logical, if TRUE generates random combos only once per side
(cycle 1) and reuses them in subsequent cycles. Saves time but reduces diversity (default FALSE)}

\item{distance_method}{Character, method for comparing states during bridge
selection. One of "manhattan" (sum of absolute differences) or "breakpoints"
(number of adjacency violations). Default "manhattan".}

\item{verbose}{Logical, if TRUE prints progress messages (default TRUE)}
}
\value{
List containing:
\item{path}{Character vector of operations, or NULL if not found}
\item{found}{Logical, whether a path was found}
\item{cycles}{Number of iterations used}
\item{selected_info}{Details about the selected intersection}
\item{bridge_states_start}{List of forward bridge states}
\item{bridge_states_final}{List of backward bridge states}
}
\description{
Finds a path between two permutation states using iterative cycle
expansion. Generates random operation sequences, analyzes their cycles,
and looks for intersections between forward (from start) and backward
(from final) state sets. Uses bridge states to progressively narrow
the search space.
}
\examples{
# Small example
set.seed(42)
start <- 1:6
final <- c(3L, 1L, 2L, 6L, 4L, 5L)
# result <- find_path_iterative(start, final, k = 3, max_iterations = 5)
}
