% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celestial.R
\name{convert_LRX_to_celestial}
\alias{convert_LRX_to_celestial}
\title{Convert LRX Counts to Celestial Coordinates}
\usage{
convert_LRX_to_celestial(nL, nR, nX)
}
\arguments{
\item{nL}{Integer, cumulative count of left shift operations}

\item{nR}{Integer, cumulative count of right shift operations}

\item{nX}{Integer, cumulative count of reverse operations}
}
\value{
List with components:
\item{z}{Complex number, stereographic projection coordinate}
\item{z_bar}{Complex conjugate of z}
\item{theta}{Numeric, zenith angle (from X axis)}
\item{phi}{Numeric, azimuthal angle (in LR plane)}
\item{omega_conformal}{Numeric, conformal energy (magnitude of momentum vector)}
}
\description{
Maps cumulative operation counts (Left, Right, Reverse) to spherical
celestial coordinates via stereographic projection.
}
\examples{
coords <- convert_LRX_to_celestial(10, 5, 3)
coords$theta
coords$phi
}
