% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state_processing.R
\name{calculate_differences}
\alias{calculate_differences}
\title{Calculate Manhattan Distances for All States}
\usage{
calculate_differences(
  start_state,
  reachable_states_start,
  method = "manhattan",
  use_gpu = FALSE
)
}
\arguments{
\item{start_state}{Integer vector, the reference state}

\item{reachable_states_start}{Data frame with V-columns}

\item{method}{Character, distance method (currently only "manhattan")}

\item{use_gpu}{Logical, use GPU acceleration via ggmlR if available (default FALSE)}
}
\value{
Data frame sorted by difference (ascending)
}
\description{
Computes the Manhattan distance from a reference state to every row in
a table of reachable states, adds a \code{difference} column, and sorts by it.
}
\examples{
df <- data.frame(V1 = c(1, 2), V2 = c(2, 1))
calculate_differences(c(1, 2), df)
}
