% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/celestial.R
\name{calculate_angular_distance_z}
\alias{calculate_angular_distance_z}
\title{Angular Distance Between Two Celestial Points}
\usage{
calculate_angular_distance_z(result1, result2)
}
\arguments{
\item{result1}{List with component \code{z} (complex number)}

\item{result2}{List with component \code{z} (complex number)}
}
\value{
Numeric, angular distance in radians
}
\description{
Computes the angular distance on the celestial sphere between two points
given as coordinate lists (each with a \code{z} component).
}
\examples{
c1 <- convert_LRX_to_celestial(10, 5, 3)
c2 <- convert_LRX_to_celestial(1, 1, 2)
calculate_angular_distance_z(c1, c2)
}
