% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpu.R
\name{apply_operations_batch_gpu}
\alias{apply_operations_batch_gpu}
\title{Apply operations to batch of states on GPU}
\usage{
apply_operations_batch_gpu(states_matrix, operations, k)
}
\arguments{
\item{states_matrix}{Numeric matrix (nrow x n), each row is a state}

\item{operations}{Character vector of operation codes (e.g., c("L", "R", "X"))}

\item{k}{Integer, parameter for reverse operations}
}
\value{
Numeric matrix (nrow x n) with transformed states
}
\description{
Applies a sequence of permutation operations to multiple states
simultaneously using matrix multiplication on the Vulkan backend.
}
\examples{
\donttest{
if (cayley_gpu_available()) {
  mat <- matrix(c(1,2,3,4,5, 5,4,3,2,1), nrow = 2, byrow = TRUE)
  result <- apply_operations_batch_gpu(mat, c("1", "3"), k = 4)
}
}
}
