% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cglm.R
\name{cglm}
\alias{cglm}
\title{Causal generalized linear model}
\usage{
cglm(
  formula,
  family,
  data,
  alpha = 0.05,
  pval = c("bootstrap", "chi-square"),
  B = 100,
  search = c("all", "stepwise"),
  ...
)
}
\arguments{
\item{formula}{A formula object.}

\item{family}{A distributional family object. Currently supported options are: binomial and poisson.}

\item{data}{A data frame containing the variables in the model.}

\item{alpha}{Significance level for statistical test}

\item{pval}{If pval="bootstrap", a bootstrap test is conducted to test whether Pearson risk is 1. When family="poisson" a chi-squared test can be conducted by setting pval="chi-square".}

\item{B}{Number of bootstrap samples when pval="bootstrap". Default is 100.}

\item{search}{If search="stepwise", a greedy forward stepwise search is conducted. Default is search="all", in which case all possible submodels are considered.}

\item{...}{Further arguments to be passed to the glm function.}
}
\value{
A glm object of the selected causal submodel.
}
\description{
This function does a search for a causal submodel within the generalized linear model provided.
}
\examples{
###################################
#causal Poisson glm#################
n<-1000
set.seed(123)
X1<-rnorm(n,0,1)
Y<-rpois(n,exp(X1))
X2<-log(Y+1)+rnorm(n,0,0.3)
data<-data.frame(X1, X2, Y)
cm_all<-cglm(Y ~ X1+X2,"poisson",data,pval="chi-square",search="all")
cm_all$model.opt
cm_step<-cglm(Y ~ X1+X2,"poisson",data,pval="chi-square",search="stepwise")
cm_step$model.opt
\donttest{
##########################
#causal logistic glm#######
n<-2000
set.seed(123)
X1<-rnorm(n,0,1)
Y<-rbinom(n,1,exp(X1)/(1+exp(X1)))
flip<-rbinom(n,1,0.1)
X2<-(1-flip)*Y+rnorm(n,0,0.3)
data<-data.frame(X1, X2, Y)
set.seed(1)
cm_all<-cglm(Y ~ X1+X2,"binomial",data,pval="bootstrap",search="all")
cm_all$model.opt
set.seed(1)
cm_step<-cglm(Y ~ X1+X2,"binomial",data,pval="bootstrap",search="stepwise")
cm_step$model.opt
#bigger simulation with 5 covariates
set.seed(12)
n<-3000
X1<-rnorm(n,0,1)
X2<-rnorm(n,X1,0.5)
X3<-rnorm(n,0,1)
X4<-rnorm(n,X2,.5)
Y<-rbinom(n,1,exp(.8*X2-.9*X3)/(1+exp(.8*X2-.9*X3)))
flip<-rbinom(n,1,0.1)
X5<-(1-flip)*Y+flip*(1-Y)+rnorm(n,0,.3)
dat<-data.frame(X1, X2, X3, X4, X5,Y)
set.seed(1)
mod.all <-cglm(Y~X1+X2+X3+X4+X5,"binomial",dat,pval="bootstrap",search="all")
mod.all$model.opt
set.seed(1)
mod.step <-cglm(Y~X1+X2+X3+X4+X5,"binomial",dat,pval="bootstrap",search="stepwise")
mod.step$model.opt
}
}
\references{
Polinelli, A., V. Vinciotti and E.C. Wit. (2026). "Causal generalized linear models via Pearson risk invariance" \emph{Journal of Causal
Inference}.
}
