% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_formula.R
\name{make_formula}
\alias{make_formula}
\title{Makes Formula for regression of exposure or risk factor or outcome on its parents in a causal Bayesian network directed acyclic graph.}
\usage{
make_formula(in_vars, outvar, addCustom = FALSE, custom = "")
}
\arguments{
\item{in_vars}{a list of character vectors of the parents of the exposure or risk factor or outcome which are either causes or confounders of the exposure or risk factor or outcome}

\item{outvar}{list of a single name of exposure or risk factor or outcome in form of characters}

\item{addCustom}{is a logical which is TRUE if a custom regression is to be added in or FALSE otherwise. The customised part is defined in the parameter ``custom''.}

\item{custom}{custom must start and end as follows: "~  + " with custom values between ~ and +. Custom allows customised input into regression not stated already e.g. allow for interaction of variables not listed yet e.g. "~ regionnn7 x ns(eage,df=5)+esex x ns(eage,df=5) + "}
}
\value{
\item{result }{result}
}
\description{
Given a causal Bayesian network, directed acyclic graph (DAG) where arrows representing
causal dependencies between confounders, risk factors, exposure and disease, together with a sensible probability distribution on
the graph that respects these causal dependencies. To consistently estimate causal effects that risk factors may have on each
other and on disease, we need to make a strong no unmeasured confounding assumption: that is common causes of nodes in the graph,
which may be causes of two risk factors or a cause of risk factor and disease, are also included as nodes in the graph.
Causal Bayesian networks have a local Markov property that the conditional probability distribution of any node \eqn{X_j}, given values
for the other variables in the network, only depends on the values \eqn{x_{pa_{j}} } of the parent nodes.
}
\keyword{internal}
