% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{validate_cox_initialization_input}
\alias{validate_cox_initialization_input}
\title{Validate Inputs for Catalytic Cox proportional hazards model (COX) Initialization}
\usage{
validate_cox_initialization_input(
  formula,
  data,
  syn_size,
  hazard_constant,
  entry_points,
  x_degree
)
}
\arguments{
\item{formula}{An object of class \code{formula}. The model formula specifying the Cox model structure. It must contain a \code{Surv} object to indicate survival analysis.}

\item{data}{A \code{data.frame} containing the dataset to be used for model fitting. It should include all variables referenced in \code{formula}.}

\item{syn_size}{A positive integer indicating the size of the synthetic dataset. It is recommended that this value is at least four times the number of columns in \code{data}.}

\item{hazard_constant}{A positive numeric value representing the hazard constant for the Cox model.}

\item{entry_points}{A numeric vector representing entry times for observations. This vector should be non-negative and have a length equal to the number of rows in \code{data}.}

\item{x_degree}{A numeric vector indicating degrees for each covariate. It should be non-negative and match the number of covariates (i.e., \code{ncol(data) - 2}).}
}
\value{
Returns nothing if all checks pass; otherwise, raises an error.
}
\description{
This function performs validation checks on input parameters for initializing a catalytic Cox proportional hazards model.
It ensures that essential parameters meet requirements, such as being of the correct type, appropriate length, and having valid values.
}
\details{
This function checks:
\itemize{
\item That \code{syn_size}, \code{hazard_constant}, \code{entry_points}, and \code{x_degree} are positive values.
\item That \code{formula} includes a \code{Surv} object to be suitable for Cox models.
\item That \code{data} is a \code{data.frame}.
\item The complexity of \code{formula} to ensure it has fewer terms than the number of columns in \code{data}.
\item The length of \code{x_degree} and \code{entry_points} to match the dimensions of \code{data}.
If the conditions are not met, descriptive error messages are returned.
}
}
