% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prints.R
\name{print.cat_tune}
\alias{print.cat_tune}
\title{Print Method for \code{cat_tune} Object}
\usage{
\method{print}{cat_tune}(x, digit = 3, detail = TRUE, ...)
}
\arguments{
\item{x}{An object of class \code{cat_tune}, typically resulting from a tuning process, including
\code{cat_glm_tune}, \code{cat_cox_tune} and \code{cat_lmm_tune}.}

\item{digit}{An integer indicating the number of decimal places for printing
coefficient estimates. Default is 3.}

\item{detail}{A logical value indicating whether to include additional detailed output at the end of the summary.
If \code{TRUE}, it will print additional interpretation help.}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
The \code{x} object is returned invisibly.
}
\description{
This function prints a summary of the \code{cat_tune} object, displaying key details such as
the function name, dimensions of covariates, tau sequence, optimal tau, likelihood or risk
estimate, and the model's coefficients.
}
\details{
This method provides a comprehensive overview of the tuning process for the model,
including the tau sequence and optimal tau, along with either the maximum likelihood (for Cox models)
or minimum risk estimate (for other models). It also displays the coefficients of the model.

The function also checks if the \code{x} is a Cox model (\code{cat_cox_tune}) to adjust the interpretation
of the output.
}
