% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.cat_tune}
\alias{plot.cat_tune}
\title{Plot Likelihood or Risk Estimate vs. Tau for Tuning Model}
\usage{
\method{plot}{cat_tune}(x, digit = 2, legend_pos = "topright", text_pos = 3, ...)
}
\arguments{
\item{x}{A fitted model object of class \code{cat_tune} that contains the
results of the tuning process. This object includes the likelihood or risk estimate lists,
the tuning sequence (\code{tau_seq}), and the selected optimal \code{tau}.}

\item{digit}{An integer specifying the number of decimal places to round the
displayed values (default is 2).}

\item{legend_pos}{A character string specifying the position of the legend on
the plot (default is \code{"topright"}).}

\item{text_pos}{An integer specifying the position of the text label on the
plot (default is 3, which places the text above the point).}

\item{...}{Additional parameters to pass to other functions.}
}
\value{
A plot with the specified y-values plotted against \code{tau_seq},
including a highlighted optimal \code{tau} point.
}
\description{
This function generates a plot showing the relationship between
the tuning parameter \code{tau} and either the likelihood score (for a \code{cat_cox_tune} model)
or the risk estimate (for other models) during cross-validation or other model evaluation methods.
The plot highlights the optimal \code{tau} value and provides visual cues for
the best tuning parameter based on the specified method.
}
\details{
The function generates a line plot with \code{tau_seq} on the x-axis and either
the likelihood score or risk estimate on the y-axis. If the model is of class
\code{cat_cox_tune}, the plot shows the likelihood score, while for other models,
it shows the risk estimates. The optimal \code{tau} is marked with a red cross,
and red dashed lines are drawn to highlight the optimal point on the plot.
}
