% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_resampled_df}
\alias{get_resampled_df}
\title{Resampling Methods for Data Processing}
\usage{
get_resampled_df(
  data,
  resample_size,
  data_degree = NULL,
  resample_only = FALSE
)
}
\arguments{
\item{data}{A data frame to be resampled.}

\item{resample_size}{An integer specifying the size of the resample.}

\item{data_degree}{A numeric vector indicating the degree of each column in the data (optional).}

\item{resample_only}{A logical value indicating whether to return only the resampled data (default is FALSE).}
}
\value{
A list containing:
\item{resampled_df}{A data frame of resampled data.}
\item{resampled_df_log}{A data frame recording the resampling process for each column.}
}
\description{
This function includes various resampling methods applied to input data for each column to prepare it
for analysis. These methods help to transform the data distribution and improve model fitting.
}
\details{
\itemize{
\item \strong{Coordinate}: This method refers to the preservation of the original data values as reference coordinates during processing.
It ensures that the transformations applied are based on the initial structure of the data.
\item \strong{Deskewing}:Deskewing is the process of adjusting the data distribution to reduce skewness, making it more symmetric.
If the absolute value of skewness is greater than or equal to 1, deskewing techniques will be applied
to normalize the distribution, which can enhance model performance.
\item \strong{Smoothing}: Smoothing techniques reduce noise in the data by averaging or modifying data points.
This is especially useful when there are many unique values in the original data column, as it helps
to stabilize the dataset and prevent overfitting during model training.
\item \strong{Flattening}: Flattening modifies the data to create a more uniform distribution across its range.
This method is employed when the frequency of certain categories in categorical variables is low,
replacing some original values with randomly selected unique values from the dataset to reduce sparsity.
\item \strong{Symmetrizing}: Symmetrizing adjusts the data so that it becomes more balanced around its mean.
This is crucial for achieving better statistical properties and improving the robustness of the model
fitting process.
}
}
