% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{get_glm_lambda}
\alias{get_glm_lambda}
\title{Compute Lambda Based on Discrepancy Method}
\usage{
get_glm_lambda(
  discrepancy_method = c("mean_square_error", "mean_classification_error",
    "logistic_deviance"),
  X,
  coefs
)
}
\arguments{
\item{discrepancy_method}{Character. A string specifying the type of discrepancy method
to use. Options are \code{"mean_square_error"}, \code{"mean_classification_error"}, or \code{"logistic_deviance"}.
Default is \code{"mean_square_error"}.}

\item{X}{Matrix. The design matrix (predictors) for the GLM.}

\item{coefs}{Numeric vector. The coefficients for the GLM.}
}
\value{
Numeric. The computed lambda value based on the selected discrepancy method.
}
\description{
This function calculates a lambda value based on the selected discrepancy method
for a generalized linear model (GLM). The discrepancy method determines the
type of error or deviance used in the calculation.
}
