% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_cox_tune.R
\name{cross_validation_cox}
\alias{cross_validation_cox}
\title{Perform Cross-Validation for Catalytic Cox Proportional-Hazards Model (COX) to Select Optimal tau}
\usage{
cross_validation_cox(
  formula,
  cat_init,
  method,
  tau_seq,
  cross_validation_fold_num,
  ...
)
}
\arguments{
\item{formula}{A formula specifying the Cox model. Should at least include response variables.}

\item{cat_init}{A list containing initialized parameters for the catalytic COX.}

\item{method}{Character string specifying the optimization method used in the Cat-Cox model fitting.}

\item{tau_seq}{A numeric vector of tau values for which to estimate likelihood.}

\item{cross_validation_fold_num}{An integer indicating the number of folds for cross-validation.}

\item{...}{Additional arguments passed to the \code{cat_cox} function for model fitting.}
}
\value{
A numeric vector containing the average likelihood estimates for each tau value.
}
\description{
This function performs cross-validation for the catalytic Cox proportional-hazards model (COX) to
estimate the likelihood associated with different values of tau. It splits the data into
training and testing sets and computes prediction errors for model evaluation.
}
