% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_metrics.r
\name{rename_metrics}
\alias{rename_metrics}
\title{Rename metrics}
\usage{
rename_metrics(
  res_df,
  k = NULL,
  propensity_scored = FALSE,
  graded_relevance = FALSE
)
}
\arguments{
\item{res_df}{A data.frame with a column \code{"metric"} containing metric
names \code{"f1", "prec", "rec", "rprec"}.}

\item{k}{An integer limit on the number of predictions per document to
consider. Requires a column \code{"score"} in input \code{predicted}.}

\item{propensity_scored}{Logical, whether to use propensity scores as
weights.}

\item{graded_relevance}{A logical indicator for graded relevance. Defaults to
\code{FALSE} for binary relevance. If set to \code{TRUE}, the
\code{predicted} data.frame should contain a numeric column
\code{"relevance"} with values in the range of \eqn{[0, 1]}.}
}
\value{
The input data.frame \code{res_df} with renamed metrics for
generalised precision etc.
}
\description{
Rename metric names for generalised precision etc. The output will be renamed
if:
\describe{
\item{\code{graded_relevance == TRUE}}{prefixed with \emph{"g-"} to
indicate that metrics are computed with graded relevance.}
\item{\code{propensity_scored == TRUE}}{prefixed with \emph{"ps-"} to
indicate that metrics are computed with propensity scores.}
\item{\code{!is.null(k)}}{suffixed with \emph{"@k"} to indicate
that metrics are limited to top k predictions.}
}
}
